/*
 * Decompiled with CFR 0.152.
 */
package me.ag2s.epublib.domain;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import me.ag2s.epublib.domain.Author;
import me.ag2s.epublib.domain.Date;
import me.ag2s.epublib.domain.Identifier;
import me.ag2s.epublib.domain.MediaTypes;
import me.ag2s.epublib.util.StringUtil;

public class Metadata
implements Serializable {
    private static final long serialVersionUID = -2437262888962149444L;
    public static final String DEFAULT_LANGUAGE = "en";
    private boolean autoGeneratedId;
    private List<Author> authors = new ArrayList();
    private List<Author> contributors = new ArrayList();
    private List<Date> dates = new ArrayList();
    private String language = "en";
    private Map<QName, String> otherProperties = new HashMap();
    private List<String> rights = new ArrayList();
    private List<String> titles = new ArrayList();
    private List<Identifier> identifiers = new ArrayList();
    private List<String> subjects = new ArrayList();
    private String format = MediaTypes.EPUB.getName();
    private List<String> types = new ArrayList();
    private List<String> descriptions = new ArrayList();
    private List<String> publishers = new ArrayList();
    private Map<String, String> metaAttributes = new HashMap();

    public Metadata() {
        this.identifiers.add(new Identifier());
        this.autoGeneratedId = true;
    }

    public boolean isAutoGeneratedId() {
        return this.autoGeneratedId;
    }

    public Map<QName, String> getOtherProperties() {
        return this.otherProperties;
    }

    public void setOtherProperties(Map<QName, String> otherProperties) {
        this.otherProperties = otherProperties;
    }

    public Date addDate(Date date) {
        this.dates.add(date);
        return date;
    }

    public List<Date> getDates() {
        return this.dates;
    }

    public void setDates(List<Date> dates) {
        this.dates = dates;
    }

    public Author addAuthor(Author author) {
        this.authors.add(author);
        return author;
    }

    public List<Author> getAuthors() {
        return this.authors;
    }

    public void setAuthors(List<Author> authors) {
        this.authors = authors;
    }

    public Author addContributor(Author contributor) {
        this.contributors.add(contributor);
        return contributor;
    }

    public List<Author> getContributors() {
        return this.contributors;
    }

    public void setContributors(List<Author> contributors) {
        this.contributors = contributors;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public List<String> getSubjects() {
        return this.subjects;
    }

    public void setSubjects(List<String> subjects) {
        this.subjects = subjects;
    }

    public void setRights(List<String> rights) {
        this.rights = rights;
    }

    public List<String> getRights() {
        return this.rights;
    }

    public String getFirstTitle() {
        if (this.titles == null || this.titles.isEmpty()) {
            return "";
        }
        for (String title : this.titles) {
            if (!StringUtil.isNotBlank((String)title)) continue;
            return title;
        }
        return "";
    }

    public String addTitle(String title) {
        this.titles.add(title);
        return title;
    }

    public void setTitles(List<String> titles) {
        this.titles = titles;
    }

    public List<String> getTitles() {
        return this.titles;
    }

    public String addPublisher(String publisher) {
        this.publishers.add(publisher);
        return publisher;
    }

    public void setPublishers(List<String> publishers) {
        this.publishers = publishers;
    }

    public List<String> getPublishers() {
        return this.publishers;
    }

    public String addDescription(String description) {
        this.descriptions.add(description);
        return description;
    }

    public void setDescriptions(List<String> descriptions) {
        this.descriptions = descriptions;
    }

    public List<String> getDescriptions() {
        return this.descriptions;
    }

    public Identifier addIdentifier(Identifier identifier) {
        if (this.autoGeneratedId && !this.identifiers.isEmpty()) {
            this.identifiers.set(0, identifier);
        } else {
            this.identifiers.add(identifier);
        }
        this.autoGeneratedId = false;
        return identifier;
    }

    public void setIdentifiers(List<Identifier> identifiers) {
        this.identifiers = identifiers;
        this.autoGeneratedId = false;
    }

    public List<Identifier> getIdentifiers() {
        return this.identifiers;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getFormat() {
        return this.format;
    }

    public String addType(String type) {
        this.types.add(type);
        return type;
    }

    public List<String> getTypes() {
        return this.types;
    }

    public void setTypes(List<String> types) {
        this.types = types;
    }

    public String getMetaAttribute(String name) {
        return (String)this.metaAttributes.get(name);
    }

    public void setMetaAttributes(Map<String, String> metaAttributes) {
        this.metaAttributes = metaAttributes;
    }
}

