/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.http;

import com.qiniu.util.StringMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import okhttp3.Headers;

public class Headers {
    okhttp3.Headers innerHeaders;

    Headers(Builder builder) {
        this.innerHeaders = builder.innerBuilder.build();
    }

    private Headers() {
    }

    public static Headers of(Map<String, String> headers) {
        Headers inner = new Headers();
        inner.innerHeaders = okhttp3.Headers.of(headers);
        return inner;
    }

    public static Headers of(StringMap headers) {
        final Builder builder = new Builder();
        if (headers == null) {
            return builder.build();
        }
        headers.forEach(new StringMap.Consumer(){

            @Override
            public void accept(String key, Object value) {
                if (null != value) {
                    builder.add(key, value.toString());
                }
            }
        });
        return builder.build();
    }

    public String get(String name) {
        return this.innerHeaders.get(name);
    }

    public Set<String> names() {
        return this.innerHeaders.names();
    }

    public List<String> values(String name) {
        return this.innerHeaders.values(name);
    }

    public Builder newBuilder() {
        Builder builder = new Builder();
        builder.innerBuilder = this.innerHeaders.newBuilder();
        return builder;
    }

    public static final class Builder {
        private Headers.Builder innerBuilder = new Headers.Builder();

        public Builder add(String name, String value) {
            this.innerBuilder.add(name, value);
            return this;
        }

        public Builder addAll(Headers headers) {
            this.innerBuilder.addAll(headers.innerHeaders);
            return this;
        }

        public Builder set(String name, String value) {
            this.innerBuilder.set(name, value);
            return this;
        }

        public Headers build() {
            return new Headers(this);
        }
    }
}

