/*
 * Decompiled with CFR 0.152.
 */
package com.upyun;

import com.upyun.BaseUploader;
import com.upyun.UpException;
import com.upyun.UpYunUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParallelUploader
extends BaseUploader {
    private volatile int blockProgress;
    private int parallel = 4;
    private int[] status;

    public void setParallel(int parallel) {
        this.parallel = parallel;
    }

    public boolean resume() throws IOException, UpException {
        this.paused = false;
        return this.startUpload();
    }

    public boolean resume(String uuid, int[] status) throws IOException, UpException {
        this.uuid = uuid;
        this.status = status;
        if (uuid == null || status == null || status.length != this.totalBlock - 2) {
            throw new UpException("uuid or status is wrong, please restart!");
        }
        this.paused = false;
        return this.startUpload();
    }

    public ParallelUploader(String bucketName, String userName, String password) {
        super(bucketName, userName, password);
    }

    @Override
    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public boolean upload(String filePath, String uploadPath, Map<String, String> params) throws IOException, UpException {
        this.init(filePath, uploadPath, params);
        if (this.status == null || this.status.length != this.totalBlock - 2 || this.uuid == null) {
            this.status = new int[this.totalBlock - 2];
        }
        this.params.put("X-Upyun-Multi-Disorder", "true");
        return this.startUpload();
    }

    public int[] getStatus() {
        return this.status;
    }

    public void setStatus(int[] status) {
        this.status = status;
    }

    @Override
    boolean processUpload() throws IOException, UpException {
        this.blockProgress = 0;
        ExecutorService uploadExecutor = Executors.newFixedThreadPool(this.parallel);
        for (int i = 0; i < this.totalBlock - 2; ++i) {
            Future<?> future = uploadExecutor.submit(this.uploadBlock(i));
            try {
                future.get();
                continue;
            }
            catch (Exception e) {
                uploadExecutor.shutdown();
                if (this.randomAccessFile != null) {
                    this.randomAccessFile.close();
                    this.randomAccessFile = null;
                }
                throw new UpException(e.getMessage());
            }
        }
        uploadExecutor.shutdown();
        try {
            uploadExecutor.awaitTermination(Long.MAX_VALUE, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return this.completeUpload();
    }

    private Runnable uploadBlock(final int index) {
        return new Runnable(){

            public void run() {
                try {
                    if (ParallelUploader.this.paused) {
                        throw new UpException("upload paused");
                    }
                    if (ParallelUploader.this.status[index] == 1) {
                        if (ParallelUploader.this.onProgressListener != null) {
                            ParallelUploader.this.onProgressListener.onProgress(ParallelUploader.this.blockProgress + 2, ParallelUploader.this.totalBlock);
                        }
                        ParallelUploader.this.blockProgress++;
                        return;
                    }
                    if (ParallelUploader.this.status[index] == 2) {
                        return;
                    }
                    ((ParallelUploader)ParallelUploader.this).status[index] = 2;
                    byte[] data = ParallelUploader.this.readBlockByIndex(index);
                    RequestBody requestBody = RequestBody.create(null, (byte[])data);
                    String date = ParallelUploader.this.getGMTDate();
                    String md5 = null;
                    if (ParallelUploader.this.checkMD5) {
                        md5 = UpYunUtils.md5(data);
                    }
                    String sign = UpYunUtils.sign("PUT", date, ParallelUploader.this.uri, ParallelUploader.this.userName, ParallelUploader.this.password, md5).trim();
                    Request.Builder builder = new Request.Builder().url(ParallelUploader.this.url).header("Date", date).header("Authorization", sign).header("X-Upyun-Multi-Stage", "upload").header("X-Upyun-Multi-UUID", ParallelUploader.this.uuid).header("X-Upyun-Part-ID", index + "").header("User-Agent", "upyun-java-sdk/4.2.0").put(requestBody);
                    if (md5 != null) {
                        builder.header("Content-MD5", md5);
                    }
                    Response response = ParallelUploader.this.uploadRequest(builder);
                    ParallelUploader.this.uuid = response.header("X-Upyun-Multi-UUID", "");
                    ((ParallelUploader)ParallelUploader.this).status[index] = 1;
                }
                catch (Exception e) {
                    ((ParallelUploader)ParallelUploader.this).status[index] = 3;
                    throw new RuntimeException(e.getMessage());
                }
            }
        };
    }

    private Response uploadRequest(Request.Builder builder) {
        try {
            Response response = this.mClient.newCall(builder.build()).execute();
            if (!response.isSuccessful()) {
                int x_error_code = Integer.parseInt(response.header("X-Error-Code", "-1"));
                if (x_error_code == 40011061 || x_error_code == 40011059) {
                    this.uuid = null;
                }
                throw new RuntimeException(response.body().string());
            }
            if (this.onProgressListener != null) {
                this.onProgressListener.onProgress(this.blockProgress + 2, this.totalBlock);
            }
            ++this.blockProgress;
            return response;
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
    }

    @Override
    boolean completeUpload() throws IOException, UpException {
        this.completeRequest();
        this.status = null;
        this.uuid = null;
        return true;
    }
}

