/*
 * Decompiled with CFR 0.152.
 */
package com.upyun;

import com.upyun.UpException;
import com.upyun.UpYunUtils;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.Proxy;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.internal.Util;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestManager {
    private final String SEPARATOR = "/";
    private final String AUTHORIZATION = "Authorization";
    private final String DATE = "Date";
    private final String METHOD_HEAD = "HEAD";
    private final String METHOD_GET = "GET";
    private final String METHOD_PUT = "PUT";
    private final String METHOD_POST = "POST";
    private final String METHOD_DELETE = "DELETE";
    private OkHttpClient mClient;
    public static final String ED_AUTO = "https://v0.api.upyun.com";
    public static final String ED_TELECOM = "https://v1.api.upyun.com";
    public static final String ED_CNC = "https:/v2.api.upyun.com";
    public static final String ED_CTT = "https://v3.api.upyun.com";
    public boolean debug = false;
    private int timeout = 30;
    private String apiDomain = "https://v0.api.upyun.com";
    private String contentMD5 = null;
    private String fileSecret = null;
    protected String bucketName = null;
    protected String userName = null;
    protected String password = null;

    public RestManager(String bucketName, String userName, String password) {
        this.bucketName = bucketName;
        this.userName = userName;
        this.password = UpYunUtils.md5(password);
        this.mClient = new OkHttpClient.Builder().connectTimeout((long)this.timeout, TimeUnit.SECONDS).readTimeout((long)this.timeout, TimeUnit.SECONDS).writeTimeout((long)this.timeout, TimeUnit.SECONDS).build();
    }

    public void setApiDomain(String domain) {
        this.apiDomain = domain;
    }

    public String getApiDomain() {
        return this.apiDomain;
    }

    public void setTimeout(int second) {
        this.timeout = second;
        this.mClient = this.mClient.newBuilder().connectTimeout((long)this.timeout, TimeUnit.SECONDS).readTimeout((long)this.timeout, TimeUnit.SECONDS).writeTimeout((long)this.timeout, TimeUnit.SECONDS).build();
    }

    public void setProxy(Proxy proxy) {
        this.mClient = this.mClient.newBuilder().proxy(proxy).build();
    }

    public int getTimeout() {
        return this.timeout;
    }

    public String version() {
        return "upyun-java-sdk/4.2.0";
    }

    public Response writeFile(String filePath, byte[] data, Map<String, String> params) throws IOException, UpException {
        return this.request("PUT", filePath, RequestBody.create(null, (byte[])data), params);
    }

    public Response writeFile(String filePath, File file, Map<String, String> params) throws IOException, UpException {
        return this.request("PUT", filePath, RequestBody.create(null, (File)file), params);
    }

    public Response writeFile(String filePath, InputStream inputStream, Map<String, String> params) throws IOException, UpException {
        return this.request("PUT", filePath, this.create(null, inputStream), params);
    }

    public Response copyFile(String path, String sourcePath, Map<String, String> params) throws IOException, UpException {
        if (params == null) {
            params = new HashMap<String, String>();
        }
        params.put(PARAMS.X_UPYUN_COPY_SOURCE.getValue(), sourcePath);
        return this.request("PUT", path, RequestBody.create(null, (String)""), params);
    }

    public Response moveFile(String path, String sourcePath, Map<String, String> params) throws IOException, UpException {
        if (params == null) {
            params = new HashMap<String, String>();
        }
        params.put(PARAMS.X_UPYUN_COPY_SOURCE.getValue(), sourcePath);
        return this.request("PUT", path, RequestBody.create(null, (String)""), params);
    }

    public Response readFile(String filePath) throws IOException, UpException {
        return this.request("GET", filePath, null, null);
    }

    public Response deleteFile(String filePath, Map<String, String> params) throws IOException, UpException {
        return this.request("DELETE", filePath, null, params);
    }

    public Response mkDir(String filePath) throws IOException, UpException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(PARAMS.MAKE_DIR.getValue(), "true");
        return this.request("POST", filePath, RequestBody.create(null, (String)""), params);
    }

    public Response rmDir(String filePath) throws IOException, UpException {
        return this.request("DELETE", filePath, null, null);
    }

    public Response getFileInfo(String filePath) throws IOException, UpException {
        return this.request("HEAD", filePath, null, null);
    }

    public Response readDirIter(String path, Map<String, String> params) throws IOException, UpException {
        return this.request("GET", path, null, params);
    }

    public Response getBucketUsage() throws IOException, UpException {
        return this.request("GET", "/?usage", null, null);
    }

    private String getGMTDate() {
        SimpleDateFormat formater = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
        formater.setTimeZone(TimeZone.getTimeZone("GMT"));
        return formater.format(new Date());
    }

    private RequestBody create(final MediaType mediaType, final InputStream inputStream) {
        return new RequestBody(){

            public MediaType contentType() {
                return mediaType;
            }

            public long contentLength() {
                try {
                    return inputStream.available();
                }
                catch (IOException e) {
                    return 0L;
                }
            }

            public void writeTo(BufferedSink bufferedSink) throws IOException {
                Source source = null;
                try {
                    source = Okio.source((InputStream)inputStream);
                    bufferedSink.writeAll(source);
                }
                finally {
                    Util.closeQuietly((Closeable)source);
                }
            }
        };
    }

    private Response request(String method, String filePath, RequestBody body, Map<String, String> params) throws UpException, IOException {
        String date = this.getGMTDate();
        String uriPath = "/" + this.bucketName + filePath;
        String sign = UpYunUtils.sign(method, date, uriPath, this.userName, this.password, params == null ? null : params.get(PARAMS.CONTENT_MD5.getValue()));
        String url = this.apiDomain + uriPath;
        Request.Builder builder = new Request.Builder().url(url).header("Date", date).header("Authorization", sign).header("User-Agent", "upyun-java-sdk/4.2.0").method(method, body);
        if (params != null) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                builder.header(entry.getKey(), entry.getValue());
            }
        }
        return this.mClient.newCall(builder.build()).execute();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PARAMS {
        MAKE_DIR("folder"),
        X_UPYUN_COPY_SOURCE("X-Upyun-Copy-Source"),
        X_UPYUN_MOVE_SOURCE("X-Upyun-Move-Source"),
        X_LIST_ITER("x-list-iter"),
        X_LIST_LIMIT("x-list-limit"),
        X_LIST_ORDER("x-list-order"),
        ACCEPT("Accept"),
        X_UPYUN_ASYNC("x-upyun-async"),
        CONTENT_MD5("Content-MD5"),
        CONTENT_TYPE("Content-Type"),
        CONTENT_SECRET("Content-Secret"),
        X_UPYUN_META_X("x-upyun-meta-x"),
        X_UPYUN_META_TTL("x-upyun-meta-ttl"),
        X_GMKERL_THUMB("x-gmkerl-thumb"),
        X_UPYUN_METADATA_DIRECTIVE("X-Upyun-Metadata-Directive"),
        X_UPYUN_FILE_TYPE("x-upyun-file-type"),
        X_UPYUN_FILE_SIZE("x-upyun-file-size"),
        X_UPYUN_FILE_DATE("x-upyun-file-date");

        private final String value;

        private PARAMS(String val) {
            this.value = val;
        }

        public String getValue() {
            return this.value;
        }
    }
}

