/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.b3log.latke.cache.redis.RedisCache;
import org.b3log.latke.ioc.BeanManager;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.repository.jdbc.util.Connections;
import org.b3log.latke.servlet.AbstractServletListener;
import org.b3log.latke.servlet.RequestContext;
import org.b3log.latke.util.Requests;
import org.h2.tools.Server;

public final class Latkes {
    private static final Logger LOGGER = Logger.getLogger(Latkes.class);
    public static final ExecutorService EXECUTOR_SERVICE = Executors.newCachedThreadPool();
    public static final String VERSION = "2.5.8";
    public static long startupTimeMillis = System.currentTimeMillis();
    private static Properties localProps;
    private static Properties latkeProps;
    private static Locale locale;
    private static RuntimeMode runtimeMode;
    private static String staticResourceVersion;
    private static String contextPath;
    private static String staticPath;
    private static String scanPath;
    private static Server h2;
    private static boolean inited;
    public static final ThreadLocal<RequestContext> REQUEST_CONTEXT;
    private static String PUBLIC_IP;

    public static boolean isDocker() {
        return 1L == Latkes.currentPID();
    }

    public static long currentPID() {
        String processName = ManagementFactory.getRuntimeMXBean().getName();
        return Long.parseLong(processName.split("@")[0]);
    }

    public static String getServletInfo(ServletContext servletContext) {
        return servletContext.getServerInfo();
    }

    public static String getOperatingSystemName() {
        return System.getProperty("os.name");
    }

    public static void setLocalProps(Properties props) {
        localProps = props;
    }

    public static void setLocalProperty(String key, String value) {
        if (null == key) {
            LOGGER.log(Level.WARN, "local.props can not set null key", new Object[0]);
            return;
        }
        if (null == value) {
            LOGGER.log(Level.WARN, "local.props can not set null value", new Object[0]);
            return;
        }
        localProps.setProperty(key, value);
    }

    public static void setLakteProps(Properties props) {
        latkeProps = props;
    }

    public static void setLatkeProperty(String key, String value) {
        if (null == key) {
            LOGGER.log(Level.WARN, "latke.props can not set null key", new Object[0]);
            return;
        }
        if (null == value) {
            LOGGER.log(Level.WARN, "latke.props can not set null value", new Object[0]);
            return;
        }
        latkeProps.setProperty(key, value);
    }

    private static void loadLocalProps() {
        if (null == localProps) {
            localProps = new Properties();
        }
        try {
            InputStream resourceAsStream;
            String localPropsEnv = System.getenv("LATKE_LOCAL_PROPS");
            if (StringUtils.isNotBlank((String)localPropsEnv)) {
                LOGGER.debug("Loading local.properties from env var [$LATKE_LOCAL_PROPS=" + localPropsEnv + "]");
                resourceAsStream = new FileInputStream(localPropsEnv);
            } else {
                LOGGER.debug("Loading local.properties from classpath [/local.properties]");
                resourceAsStream = Latkes.class.getResourceAsStream("/local.properties");
            }
            if (null != resourceAsStream) {
                localProps.load(resourceAsStream);
                LOGGER.debug("Loaded local.properties");
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.DEBUG, "Loads local.properties failed, ignored", new Object[0]);
        }
    }

    private static void loadLatkeProps() {
        if (null == latkeProps) {
            latkeProps = new Properties();
        }
        try {
            InputStream resourceAsStream;
            String latkePropsEnv = System.getenv("LATKE_PROPS");
            if (StringUtils.isNotBlank((String)latkePropsEnv)) {
                LOGGER.debug("Loading latke.properties from env var [$LATKE_PROPS=" + latkePropsEnv + "]");
                resourceAsStream = new FileInputStream(latkePropsEnv);
            } else {
                LOGGER.debug("Loading latke.properties from classpath [/latke.properties]");
                resourceAsStream = Latkes.class.getResourceAsStream("/latke.properties");
            }
            if (null != resourceAsStream) {
                latkeProps.load(resourceAsStream);
                LOGGER.debug("Loaded latke.properties");
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Loads latke.properties failed", e);
            throw new RuntimeException("Loads latke.properties failed");
        }
    }

    public static String getStaticResourceVersion() {
        if (null == staticResourceVersion && null == (staticResourceVersion = Latkes.getLatkeProperty("staticResourceVersion"))) {
            staticResourceVersion = String.valueOf(startupTimeMillis);
        }
        return staticResourceVersion;
    }

    public static void setStaticResourceVersion(String staticResourceVersion) {
        Latkes.staticResourceVersion = staticResourceVersion;
    }

    public static String getServerScheme() {
        String ret = Latkes.getLatkeProperty("serverScheme");
        if (null == ret) {
            RequestContext requestContext = REQUEST_CONTEXT.get();
            if (null != requestContext) {
                HttpServletRequest request = requestContext.getRequest();
                ret = Requests.getServerScheme(request);
            } else {
                ret = "http";
            }
        }
        return ret;
    }

    public static String getServerHost() {
        String ret = Latkes.getLatkeProperty("serverHost");
        if (null == ret) {
            RequestContext requestContext = REQUEST_CONTEXT.get();
            if (null != requestContext) {
                HttpServletRequest request = requestContext.getRequest();
                ret = Requests.getServerName(request);
            } else {
                Latkes.initPublicIP();
                return PUBLIC_IP;
            }
        }
        return ret;
    }

    public static synchronized void initPublicIP() {
        if (StringUtils.isNotBlank((String)PUBLIC_IP)) {
            return;
        }
        try {
            URL url = new URL("http://checkip.amazonaws.com");
            HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
            urlConnection.setConnectTimeout(3000);
            urlConnection.setReadTimeout(3000);
            try (BufferedReader in = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));){
                PUBLIC_IP = in.readLine();
            }
            urlConnection.disconnect();
            return;
        }
        catch (Exception e) {
            try {
                PUBLIC_IP = InetAddress.getLocalHost().getHostAddress();
                return;
            }
            catch (Exception exception) {
                PUBLIC_IP = "127.0.0.1";
                return;
            }
        }
    }

    public static String getServerPort() {
        RequestContext requestContext;
        String ret = Latkes.getLatkeProperty("serverPort");
        if (null == ret && null != (requestContext = REQUEST_CONTEXT.get())) {
            ret = requestContext.getRequest().getServerPort() + "";
        }
        return ret;
    }

    public static String getServer() {
        StringBuilder serverBuilder = new StringBuilder(Latkes.getServerScheme()).append("://").append(Latkes.getServerHost());
        String port = Latkes.getServerPort();
        if (StringUtils.isNotBlank((String)port) && !"80".equals(port) && !"443".equals(port)) {
            serverBuilder.append(':').append(port);
        }
        return serverBuilder.toString();
    }

    public static String getServePath() {
        return Latkes.getServer() + Latkes.getContextPath();
    }

    public static String getStaticServerScheme() {
        String ret = Latkes.getLatkeProperty("staticServerScheme");
        if (null == ret) {
            return Latkes.getServerScheme();
        }
        return ret;
    }

    public static String getStaticServerHost() {
        String ret = Latkes.getLatkeProperty("staticServerHost");
        if (null == ret) {
            return Latkes.getServerHost();
        }
        return ret;
    }

    public static String getStaticServerPort() {
        String ret = Latkes.getLatkeProperty("staticServerPort");
        if (null == ret) {
            return Latkes.getServerPort();
        }
        return ret;
    }

    public static String getStaticServer() {
        StringBuilder staticServerBuilder = new StringBuilder(Latkes.getStaticServerScheme()).append("://").append(Latkes.getStaticServerHost());
        String port = Latkes.getStaticServerPort();
        if (StringUtils.isNotBlank((String)port) && !"80".equals(port) && !"443".equals(port)) {
            staticServerBuilder.append(':').append(port);
        }
        return staticServerBuilder.toString();
    }

    public static String getStaticServePath() {
        return Latkes.getStaticServer() + Latkes.getStaticPath();
    }

    public static String getContextPath() {
        if (null != contextPath) {
            return contextPath;
        }
        String contextPathConf = Latkes.getLatkeProperty("contextPath");
        if (null != contextPathConf) {
            contextPath = contextPathConf;
            return contextPath;
        }
        ServletContext servletContext = AbstractServletListener.getServletContext();
        contextPath = servletContext.getContextPath();
        return contextPath;
    }

    public static void setContextPath(String contextPath) {
        Latkes.contextPath = contextPath;
    }

    public static String getStaticPath() {
        if (null == staticPath && null == (staticPath = Latkes.getLatkeProperty("staticPath"))) {
            staticPath = Latkes.getContextPath();
        }
        return staticPath;
    }

    public static void setStaticPath(String staticPath) {
        Latkes.staticPath = staticPath;
    }

    public static String getScanPath() {
        if (null == scanPath) {
            scanPath = Latkes.getLatkeProperty("scanPath");
        }
        return scanPath;
    }

    public static void setScanPath(String scanPath) {
        Latkes.scanPath = scanPath;
    }

    public static synchronized void init() {
        String newTCPServer;
        if (inited) {
            return;
        }
        inited = true;
        LOGGER.log(Level.TRACE, "Initializing Latke", new Object[0]);
        Latkes.loadLatkeProps();
        Latkes.loadLocalProps();
        if (null == runtimeMode) {
            String runtimeModeValue = Latkes.getLatkeProperty("runtimeMode");
            if (null != runtimeModeValue) {
                runtimeMode = RuntimeMode.valueOf(runtimeModeValue);
            } else {
                LOGGER.log(Level.TRACE, "Can't parse runtime mode in latke.properties, default to [PRODUCTION]", new Object[0]);
                runtimeMode = RuntimeMode.PRODUCTION;
            }
        }
        if (RuntimeMode.DEVELOPMENT == Latkes.getRuntimeMode()) {
            LOGGER.warn("!!!!Runtime mode is [" + (Object)((Object)RuntimeMode.DEVELOPMENT) + "], please make sure configured it with [" + (Object)((Object)RuntimeMode.PRODUCTION) + "] in latke.properties if deployed on production environment!!!!");
        } else {
            LOGGER.log(Level.DEBUG, "Runtime mode is [{0}]", new Object[]{Latkes.getRuntimeMode()});
        }
        RuntimeDatabase runtimeDatabase = Latkes.getRuntimeDatabase();
        LOGGER.log(Level.DEBUG, "Runtime database is [{0}]", new Object[]{runtimeDatabase});
        if (RuntimeDatabase.H2 == runtimeDatabase && "true".equals(newTCPServer = Latkes.getLocalProperty("newTCPServer"))) {
            LOGGER.log(Level.DEBUG, "Starting H2 TCP server", new Object[0]);
            String jdbcURL = Latkes.getLocalProperty("jdbc.URL");
            if (StringUtils.isBlank((String)jdbcURL)) {
                throw new IllegalStateException("The jdbc.URL in local.properties is required");
            }
            String[] parts = jdbcURL.split(":");
            if (5 != parts.length) {
                throw new IllegalStateException("jdbc.URL should like [jdbc:h2:tcp://localhost:8250/~/] (the port part is required)");
            }
            String port = parts[parts.length - 1];
            port = StringUtils.substringBefore((String)port, (String)"/");
            LOGGER.log(Level.TRACE, "H2 TCP port [{0}]", port);
            try {
                h2 = Server.createTcpServer((String[])new String[]{"-tcpPort", port, "-tcpAllowOthers"}).start();
            }
            catch (SQLException e) {
                String msg = "H2 TCP server create failed";
                LOGGER.log(Level.ERROR, "H2 TCP server create failed", e);
                throw new IllegalStateException("H2 TCP server create failed");
            }
            LOGGER.log(Level.DEBUG, "Started H2 TCP server", new Object[0]);
        }
        RuntimeCache runtimeCache = Latkes.getRuntimeCache();
        LOGGER.log(Level.INFO, "Runtime cache is [{0}]", new Object[]{runtimeCache});
        locale = new Locale("en_US");
        LOGGER.log(Level.INFO, "Initialized Latke", new Object[0]);
    }

    public static RuntimeMode getRuntimeMode() {
        if (null == runtimeMode) {
            throw new RuntimeException("Runtime mode has not been initialized!");
        }
        return runtimeMode;
    }

    public static void setRuntimeMode(RuntimeMode runtimeMode) {
        Latkes.runtimeMode = runtimeMode;
    }

    public static RuntimeCache getRuntimeCache() {
        String runtimeCache = Latkes.getLocalProperty("runtimeCache");
        if (null == runtimeCache) {
            LOGGER.debug("Not found [runtimeCache] in local.properties, uses [LOCAL_LRU] as default");
            return RuntimeCache.LOCAL_LRU;
        }
        return RuntimeCache.valueOf(runtimeCache);
    }

    public static RuntimeDatabase getRuntimeDatabase() {
        String runtimeDatabase = Latkes.getLocalProperty("runtimeDatabase");
        if (null == runtimeDatabase) {
            throw new RuntimeException("Please configures runtime database in local.properties!");
        }
        RuntimeDatabase ret = RuntimeDatabase.valueOf(runtimeDatabase);
        if (null == ret) {
            throw new RuntimeException("Please configures a valid runtime database in local.properties!");
        }
        return ret;
    }

    public static Locale getLocale() {
        if (null == locale) {
            throw new RuntimeException("Default locale has not been initialized!");
        }
        return locale;
    }

    public static void setLocale(Locale locale) {
        Latkes.locale = locale;
    }

    public static String getLocalProperty(String key) {
        String ret = localProps.getProperty(key);
        if (StringUtils.isBlank((String)ret)) {
            return ret;
        }
        ret = Latkes.replaceEnvVars(ret);
        return ret;
    }

    public static String getLatkeProperty(String key) {
        String ret = latkeProps.getProperty(key);
        if (StringUtils.isBlank((String)ret)) {
            return ret;
        }
        ret = Latkes.replaceEnvVars(ret);
        return ret;
    }

    public static void shutdown() {
        try {
            String newTCPServer;
            EXECUTOR_SERVICE.shutdown();
            if (RuntimeCache.REDIS == Latkes.getRuntimeCache()) {
                RedisCache.shutdown();
            }
            Connections.shutdownConnectionPool();
            if (RuntimeDatabase.H2 == Latkes.getRuntimeDatabase() && "true".equals(newTCPServer = Latkes.getLocalProperty("newTCPServer"))) {
                h2.stop();
                h2.shutdown();
                LOGGER.log(Level.INFO, "Closed H2 TCP server", new Object[0]);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Shutdowns Latke failed", e);
        }
        BeanManager.close();
        Enumeration<Driver> drivers = DriverManager.getDrivers();
        while (drivers.hasMoreElements()) {
            Driver driver = drivers.nextElement();
            try {
                DriverManager.deregisterDriver(driver);
                LOGGER.log(Level.TRACE, "Unregistered JDBC driver [" + driver + "]", new Object[0]);
            }
            catch (SQLException e) {
                LOGGER.log(Level.ERROR, "Unregister JDBC driver [" + driver + "] failed", e);
            }
        }
    }

    public static String getSkinName(String skinDirName) {
        try {
            Properties ret = new Properties();
            File file = Latkes.getWebFile("/skins/" + skinDirName + "/skin.properties");
            ret.load(new FileInputStream(file));
            return ret.getProperty("name");
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Read skin [" + skinDirName + "]'s configuration failed: " + e.getMessage(), new Object[0]);
            return null;
        }
    }

    public static File getWebFile(String path) {
        ServletContext servletContext = AbstractServletListener.getServletContext();
        try {
            URL resource = servletContext.getResource(path);
            if (null == resource) {
                return null;
            }
            File ret = FileUtils.toFile((URL)resource);
            if (null == ret) {
                File tempdir = (File)servletContext.getAttribute("javax.servlet.context.tempdir");
                ret = new File(tempdir.getPath() + path);
                FileUtils.copyURLToFile((URL)resource, (File)ret);
                ret.deleteOnExit();
            }
            return ret;
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Reads file [path=" + path + "] failed", e);
            return null;
        }
    }

    private static String replaceEnvVars(String val) {
        String ret = val;
        String[] envVars = StringUtils.substringsBetween((String)ret, (String)"${", (String)"}");
        if (null != envVars) {
            for (int i = 0; i < envVars.length; ++i) {
                String envKey = envVars[i];
                String envVal = System.getenv(envKey);
                if (StringUtils.isBlank((String)envVal)) {
                    envVal = "";
                }
                ret = StringUtils.replace((String)ret, (String)("${" + envKey + "}"), (String)envVal);
            }
        }
        return ret;
    }

    private Latkes() {
    }

    static {
        REQUEST_CONTEXT = new InheritableThreadLocal<RequestContext>();
    }

    public static enum RuntimeMode {
        DEVELOPMENT,
        PRODUCTION;

    }

    public static enum RuntimeCache {
        NONE,
        LOCAL_LRU,
        REDIS;

    }

    public static enum RuntimeDatabase {
        NONE,
        ORACLE,
        MYSQL,
        H2,
        MSSQL;

    }
}

