/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.cache;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.b3log.latke.Latkes;
import org.b3log.latke.cache.Cache;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;

public final class CacheFactory {
    private static final Logger LOGGER = Logger.getLogger(CacheFactory.class);
    private static final Map<String, Cache> CACHES = Collections.synchronizedMap(new HashMap());

    private CacheFactory() {
    }

    public static synchronized Cache getCache(String cacheName) {
        LOGGER.log(Level.INFO, "Constructing cache [name={0}]....", cacheName);
        Cache ret = CACHES.get(cacheName);
        try {
            if (null == ret) {
                Class<?> cacheClass;
                switch (Latkes.getRuntimeCache()) {
                    case LOCAL_LRU: {
                        cacheClass = Class.forName("org.b3log.latke.cache.caffeine.CaffeineCache");
                        break;
                    }
                    case REDIS: {
                        cacheClass = Class.forName("org.b3log.latke.cache.redis.RedisCache");
                        break;
                    }
                    case NONE: {
                        cacheClass = Class.forName("org.b3log.latke.cache.NoneCache");
                        break;
                    }
                    default: {
                        throw new RuntimeException("Latke runs in the hell.... Please set the environment correctly");
                    }
                }
                ret = (Cache)cacheClass.newInstance();
                ret.setName(cacheName);
                CACHES.put(cacheName, ret);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Can not get cache: " + e.getMessage(), e);
        }
        LOGGER.log(Level.INFO, "Constructed cache [name={0}, runtime={1}]", new Object[]{cacheName, Latkes.getRuntimeCache()});
        return ret;
    }

    public static synchronized void clear() {
        for (Map.Entry<String, Cache> entry : CACHES.entrySet()) {
            Cache cache = entry.getValue();
            cache.clear();
            LOGGER.log(Level.TRACE, "Cleared cache [name={0}]", entry.getKey());
        }
    }
}

