/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.event;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.b3log.latke.event.AbstractEventQueue;
import org.b3log.latke.event.Event;
import org.b3log.latke.event.EventManager;

final class SynchronizedEventQueue
extends AbstractEventQueue {
    private Map<String, List<Event<?>>> synchronizedEvents = new HashMap();
    private EventManager eventManager;

    SynchronizedEventQueue(EventManager eventManager) {
        this.eventManager = eventManager;
    }

    synchronized void fireEvent(Event<?> event) {
        String eventType = event.getType();
        List<Event<?>> events = this.synchronizedEvents.get(eventType);
        if (null == events) {
            events = new ArrayList();
            this.synchronizedEvents.put(eventType, events);
        }
        events.add(event);
        this.setChanged();
        this.notifyListeners(event);
    }

    synchronized void removeEvent(Event<?> event) {
        this.synchronizedEvents.get(event.getType()).remove(event);
    }
}

