/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.ioc.annotated;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import org.b3log.latke.ioc.Inject;
import org.b3log.latke.ioc.annotated.AnnotatedField;
import org.b3log.latke.ioc.annotated.AnnotatedFieldImpl;
import org.b3log.latke.ioc.annotated.AnnotatedType;
import org.b3log.latke.util.Reflections;

public class AnnotatedTypeImpl<T>
implements AnnotatedType<T> {
    private Class<T> beanClass;
    private Set<AnnotatedField<? super T>> annotatedFields = new HashSet<AnnotatedField<? super T>>();

    public AnnotatedTypeImpl(Class<T> beanClass) {
        this.beanClass = beanClass;
        this.initAnnotatedFields();
    }

    @Override
    public Set<AnnotatedField<? super T>> getFields() {
        return this.annotatedFields;
    }

    private void initAnnotatedFields() {
        Set<Field> hiddenFields = Reflections.getHiddenFields(this.beanClass);
        this.inject(hiddenFields);
        Set<Field> inheritedFields = Reflections.getInheritedFields(this.beanClass);
        this.inject(inheritedFields);
        Set<Field> ownFields = Reflections.getOwnFields(this.beanClass);
        this.inject(ownFields);
    }

    private void inject(Set<Field> fields) {
        for (Field field : fields) {
            if (!field.isAnnotationPresent(Inject.class)) continue;
            AnnotatedFieldImpl annotatedField = new AnnotatedFieldImpl(field);
            field.setAccessible(true);
            this.annotatedFields.add(annotatedField);
        }
    }

    @Override
    public Type getBaseType() {
        return this.beanClass;
    }
}

