/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.repository;

import java.util.List;
import java.util.Map;
import org.b3log.latke.repository.Query;
import org.b3log.latke.repository.RepositoryException;
import org.b3log.latke.repository.Transaction;
import org.b3log.latke.util.CollectionUtils;
import org.json.JSONObject;

public interface Repository {
    public String add(JSONObject var1) throws RepositoryException;

    public void update(String var1, JSONObject var2, String ... var3) throws RepositoryException;

    public void remove(String var1) throws RepositoryException;

    public void remove(Query var1) throws RepositoryException;

    public JSONObject get(String var1) throws RepositoryException;

    public Map<String, JSONObject> get(Iterable<String> var1) throws RepositoryException;

    public boolean has(String var1) throws RepositoryException;

    public JSONObject get(Query var1) throws RepositoryException;

    default public List<JSONObject> getList(Query query) throws RepositoryException {
        JSONObject result = this.get(query);
        return CollectionUtils.jsonArrayToList(result.optJSONArray("rslts"));
    }

    default public JSONObject getFirst(Query query) throws RepositoryException {
        query.setPageCount(1).setPage(1, 1);
        List<JSONObject> records = this.getList(query);
        if (records.isEmpty()) {
            return null;
        }
        return records.get(0);
    }

    public List<JSONObject> select(String var1, Object ... var2) throws RepositoryException;

    public List<JSONObject> getRandomly(int var1) throws RepositoryException;

    public long count() throws RepositoryException;

    public long count(Query var1) throws RepositoryException;

    public String getName();

    public Transaction beginTransaction();

    public boolean hasTransactionBegun();

    public boolean isWritable();

    public void setWritable(boolean var1);

    public void setDebug(boolean var1);
}

