/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.repository.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.b3log.latke.repository.jdbc.JdbcDatabase;
import org.b3log.latke.repository.jdbc.mapping.Mapping;
import org.b3log.latke.repository.jdbc.util.Connections;
import org.b3log.latke.repository.jdbc.util.JdbcUtil;
import org.b3log.latke.repository.jdbc.util.RepositoryDefinition;

public abstract class AbstractJdbcDatabaseSolution
implements JdbcDatabase {
    private Map<String, Mapping> jdbcTypeMapping = new HashMap<String, Mapping>();

    public void registerType(String type, Mapping mapping) {
        this.jdbcTypeMapping.put(type, mapping);
    }

    @Override
    public boolean createTable(RepositoryDefinition repositoryDefinition) throws SQLException {
        try (Connection connection = Connections.getConnection();){
            StringBuilder createTableSql = new StringBuilder();
            this.createTableHead(createTableSql, repositoryDefinition);
            this.createTableBody(createTableSql, repositoryDefinition);
            this.createTableEnd(createTableSql, repositoryDefinition);
            boolean bl = JdbcUtil.executeSql(createTableSql.toString(), connection, false);
            return bl;
        }
    }

    protected abstract void createTableHead(StringBuilder var1, RepositoryDefinition var2);

    protected abstract void createTableBody(StringBuilder var1, RepositoryDefinition var2);

    protected abstract void createTableEnd(StringBuilder var1, RepositoryDefinition var2);

    public Map<String, Mapping> getJdbcTypeMapping() {
        return this.jdbcTypeMapping;
    }
}

