/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.repository.jdbc;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.b3log.latke.Latkes;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.repository.jdbc.AbstractJdbcDatabaseSolution;
import org.b3log.latke.repository.jdbc.JdbcDatabase;
import org.b3log.latke.repository.jdbc.JdbcRepository;
import org.b3log.latke.repository.jdbc.util.RepositoryDefinition;

public final class JdbcFactory
implements JdbcDatabase {
    private static final Logger LOGGER = Logger.getLogger(JdbcRepository.class);
    private AbstractJdbcDatabaseSolution databaseSolution;
    private static JdbcFactory jdbcFactory;
    private static Map<Latkes.RuntimeDatabase, String> jdbcDatabaseSolutionMap;

    @Override
    public boolean existTable(String tableName) {
        return this.databaseSolution.existTable(tableName);
    }

    @Override
    public boolean createTable(RepositoryDefinition repositoryDefinition) throws SQLException {
        return this.databaseSolution.createTable(repositoryDefinition);
    }

    public static synchronized JdbcFactory getInstance() {
        if (null == jdbcFactory) {
            jdbcFactory = new JdbcFactory();
        }
        return jdbcFactory;
    }

    private JdbcFactory() {
        String databaseSolutionClassName = jdbcDatabaseSolutionMap.get((Object)Latkes.getRuntimeDatabase());
        try {
            this.databaseSolution = (AbstractJdbcDatabaseSolution)Class.forName(databaseSolutionClassName).newInstance();
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Init JdbcDatabaseSolution [" + databaseSolutionClassName + "] instance failed", e);
        }
    }

    @Override
    public String queryPage(int start, int end, String selectSql, String filterSql, String orderBySql, String tableName) {
        return this.databaseSolution.queryPage(start, end, selectSql, filterSql, orderBySql, tableName);
    }

    @Override
    public String getRandomlySql(String tableName, int fetchSize) {
        return this.databaseSolution.getRandomlySql(tableName, fetchSize);
    }

    static {
        jdbcDatabaseSolutionMap = new HashMap<Latkes.RuntimeDatabase, String>(){
            {
                this.put(Latkes.RuntimeDatabase.MYSQL, "org.b3log.latke.repository.mysql.MysqlJdbcDatabaseSolution");
                this.put(Latkes.RuntimeDatabase.H2, "org.b3log.latke.repository.h2.H2JdbcDatabaseSolution");
                this.put(Latkes.RuntimeDatabase.MSSQL, "org.b3log.latke.repository.sqlserver.SQLServerJdbcDatabaseSolution");
                this.put(Latkes.RuntimeDatabase.ORACLE, "org.b3log.latke.repository.oracle.OracleJdbcDatabaseSolution");
            }
        };
    }
}

