/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.repository.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.repository.Transaction;
import org.b3log.latke.repository.jdbc.JdbcRepository;
import org.b3log.latke.repository.jdbc.util.Connections;

public final class JdbcTransaction
implements Transaction {
    private static final Logger LOGGER = Logger.getLogger(JdbcTransaction.class);
    private Connection connection = Connections.getConnection();
    private boolean isActive;
    private boolean isProgrammatic;

    public JdbcTransaction() throws SQLException {
        this.connection.setAutoCommit(false);
        this.isActive = true;
    }

    @Override
    public void commit() {
        boolean succ = false;
        try {
            this.connection.commit();
            succ = true;
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Commits transaction [" + this.getId() + "] failed", e);
        }
        if (succ) {
            this.dispose();
        }
    }

    @Override
    public void rollback() {
        try {
            this.connection.rollback();
        }
        catch (SQLException e) {
            throw new RuntimeException("rollback mistake", e);
        }
        finally {
            this.dispose();
        }
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    public boolean isProgrammatic() {
        return this.isProgrammatic;
    }

    public void setProgrammatic(boolean isProgrammatic) {
        this.isProgrammatic = isProgrammatic;
    }

    public void dispose() {
        try {
            this.connection.close();
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Disposes transaction [" + this.getId() + "] failed", e);
        }
        finally {
            this.isActive = false;
            this.connection = null;
            JdbcRepository.TX.set(null);
        }
    }

    public Connection getConnection() {
        return this.connection;
    }
}

