/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.repository.jdbc.mapping;

import org.b3log.latke.repository.jdbc.mapping.Mapping;
import org.b3log.latke.repository.jdbc.util.FieldDefinition;

public class StringMapping
implements Mapping {
    @Override
    public String toDataBaseSting(FieldDefinition definition) {
        Integer length;
        StringBuilder sql = new StringBuilder();
        sql.append(definition.getName());
        if (null == definition.getLength()) {
            definition.setLength(0);
        }
        if (255 < (length = definition.getLength())) {
            if (0xFFFFFF < length) {
                sql.append(" longtext");
            } else if (65535 < length) {
                sql.append(" mediumtext");
            } else {
                sql.append(" text");
            }
        } else {
            sql.append(" varchar(").append(length < 1 ? 128 : length);
            sql.append(")");
        }
        if (!definition.getNullable().booleanValue()) {
            sql.append(" not null");
        }
        return sql.toString();
    }
}

