/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.repository.jdbc.util;

import java.io.IOException;
import java.io.Reader;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.b3log.latke.Latkes;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.repository.RepositoryException;
import org.b3log.latke.repository.jdbc.util.FieldDefinition;
import org.b3log.latke.repository.jdbc.util.JdbcRepositories;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class JdbcUtil {
    private static final Logger LOGGER = Logger.getLogger(JdbcUtil.class);

    public static boolean executeSql(String sql, Connection connection, boolean isDebug) throws SQLException {
        Statement statement;
        if (isDebug || LOGGER.isTraceEnabled()) {
            LOGGER.log(Level.INFO, "Executing SQL [" + sql + "]", new Object[0]);
        }
        boolean isSuccess = !(statement = connection.createStatement()).execute(sql);
        statement.close();
        return isSuccess;
    }

    public static boolean executeSql(String sql, List<Object> paramList, Connection connection, boolean isDebug) throws SQLException {
        if (isDebug || LOGGER.isTraceEnabled()) {
            LOGGER.log(Level.INFO, "Executing SQL [" + sql + "]", new Object[0]);
        }
        PreparedStatement preparedStatement = connection.prepareStatement(sql);
        for (int i = 1; i <= paramList.size(); ++i) {
            preparedStatement.setObject(i, paramList.get(i - 1));
        }
        boolean isSuccess = preparedStatement.execute();
        preparedStatement.close();
        return isSuccess;
    }

    public static JSONObject queryJsonObject(String sql, List<Object> paramList, Connection connection, String tableName, boolean isDebug) throws SQLException, JSONException, RepositoryException {
        return JdbcUtil.queryJson(sql, paramList, connection, true, tableName, isDebug);
    }

    public static JSONArray queryJsonArray(String sql, List<Object> paramList, Connection connection, String tableName, boolean isDebug) throws SQLException, JSONException, RepositoryException {
        JSONObject jsonObject = JdbcUtil.queryJson(sql, paramList, connection, false, tableName, isDebug);
        return jsonObject.getJSONArray("rslts");
    }

    private static JSONObject queryJson(String sql, List<Object> paramList, Connection connection, boolean ifOnlyOne, String tableName, boolean isDebug) throws SQLException, JSONException, RepositoryException {
        if (isDebug || LOGGER.isTraceEnabled()) {
            LOGGER.log(Level.INFO, "Executing SQL [" + sql + "]", new Object[0]);
        }
        PreparedStatement preparedStatement = connection.prepareStatement(sql);
        for (int i = 1; i <= paramList.size(); ++i) {
            preparedStatement.setObject(i, paramList.get(i - 1));
        }
        ResultSet resultSet = preparedStatement.executeQuery();
        JSONObject jsonObject = JdbcUtil.resultSetToJsonObject(resultSet, ifOnlyOne, tableName);
        resultSet.close();
        preparedStatement.close();
        return jsonObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JSONObject resultSetToJsonObject(ResultSet resultSet, boolean ifOnlyOne, String tableName) throws SQLException, JSONException, RepositoryException {
        JSONObject jsonObject;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        List<FieldDefinition> definitionList = JdbcRepositories.getKeys(tableName);
        if (null == definitionList) {
            LOGGER.log(Level.ERROR, "resultSetToJsonObject: null definitionList finded for table  {0}", tableName);
            throw new RepositoryException("resultSetToJsonObject: null definitionList finded for table  " + tableName);
        }
        HashMap<String, FieldDefinition> dMap = new HashMap<String, FieldDefinition>();
        for (FieldDefinition fieldDefinition : definitionList) {
            if (Latkes.RuntimeDatabase.H2 == Latkes.getRuntimeDatabase() || Latkes.RuntimeDatabase.ORACLE == Latkes.getRuntimeDatabase()) {
                dMap.put(fieldDefinition.getName().toUpperCase(), fieldDefinition);
                continue;
            }
            dMap.put(fieldDefinition.getName(), fieldDefinition);
        }
        int numColumns = resultSetMetaData.getColumnCount();
        JSONArray jsonArray = new JSONArray();
        while (resultSet.next()) {
            jsonObject = new JSONObject();
            for (int i = 1; i < numColumns + 1; ++i) {
                String columnName = resultSetMetaData.getColumnLabel(i);
                FieldDefinition definition = (FieldDefinition)dMap.get(columnName);
                if (null == definition) {
                    jsonObject.put(columnName, resultSet.getObject(columnName));
                    continue;
                }
                if ("boolean".equals(definition.getType())) {
                    jsonObject.put(definition.getName(), resultSet.getBoolean(columnName));
                    continue;
                }
                Object v = resultSet.getObject(columnName);
                if (v instanceof Clob) {
                    Clob clob = (Clob)v;
                    String str = null;
                    try {
                        str = IOUtils.toString((Reader)clob.getCharacterStream());
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.ERROR, "Cant not read column[name=" + columnName + "] in table[name=" + tableName + "] on H2", e);
                    }
                    finally {
                        try {
                            clob.free();
                        }
                        catch (Exception e) {
                            LOGGER.log(Level.ERROR, "clob.free error", e);
                        }
                    }
                    jsonObject.put(definition.getName(), str);
                    continue;
                }
                jsonObject.put(definition.getName(), v);
            }
            if (Latkes.RuntimeDatabase.ORACLE == Latkes.getRuntimeDatabase()) {
                jsonObject.remove("R__");
                JdbcUtil.fromOracleClobEmpty(jsonObject);
            }
            jsonArray.put(jsonObject);
        }
        if (ifOnlyOne) {
            if (jsonArray.length() > 0) {
                jsonObject = jsonArray.getJSONObject(0);
                return jsonObject;
            }
            return null;
        }
        jsonObject = new JSONObject();
        jsonObject.put("rslts", jsonArray);
        return jsonObject;
    }

    public static void fromOracleClobEmpty(JSONObject jsonObject) {
        Iterator<String> keys = jsonObject.keys();
        try {
            while (keys.hasNext()) {
                String valStr;
                String name = keys.next();
                Object val = jsonObject.get(name);
                if (!(val instanceof String) || !StringUtils.equals((String)(valStr = (String)val), (String)"oranil")) continue;
                jsonObject.put(name, "");
            }
        }
        catch (JSONException e) {
            LOGGER.log(Level.ERROR, "Process oracle clob empty failed", e);
        }
    }

    private JdbcUtil() {
    }
}

