/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.servlet;

import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.b3log.latke.Latkes;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.servlet.HttpMethod;
import org.b3log.latke.servlet.RequestContext;
import org.b3log.latke.servlet.function.ContextHandler;
import org.b3log.latke.servlet.handler.AfterHandleHandler;
import org.b3log.latke.servlet.handler.BeforeHandleHandler;
import org.b3log.latke.servlet.handler.ContextHandleHandler;
import org.b3log.latke.servlet.handler.ContextHandlerMeta;
import org.b3log.latke.servlet.handler.Handler;
import org.b3log.latke.servlet.handler.RouteHandler;
import org.b3log.latke.servlet.handler.StaticResourceHandler;
import org.b3log.latke.servlet.renderer.AbstractResponseRenderer;
import org.b3log.latke.servlet.renderer.Http404Renderer;

public final class DispatcherServlet
extends HttpServlet {
    private static final Logger LOGGER = Logger.getLogger(DispatcherServlet.class);
    public static final List<Handler> HANDLERS = new ArrayList<Handler>();
    private static List<Router> routers;

    public void init() {
        HANDLERS.add(0, new StaticResourceHandler(this.getServletContext()));
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) {
        DispatcherServlet.handle(request, response);
    }

    public static RequestContext handle(HttpServletRequest request, HttpServletResponse response) {
        try {
            request.setCharacterEncoding("UTF-8");
            response.setCharacterEncoding("UTF-8");
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Sets request context character encoding failed", e);
        }
        RequestContext ret = new RequestContext();
        ret.setRequest(request);
        ret.setResponse(response);
        Latkes.REQUEST_CONTEXT.set(ret);
        for (Handler handler : HANDLERS) {
            ret.addHandler(handler);
        }
        ret.handle();
        DispatcherServlet.result(ret);
        Latkes.REQUEST_CONTEXT.set(null);
        return ret;
    }

    public static void result(RequestContext context) {
        HttpServletResponse response = context.getResponse();
        if (response.isCommitted()) {
            return;
        }
        AbstractResponseRenderer renderer = context.getRenderer();
        if (null == renderer) {
            renderer = new Http404Renderer();
        }
        renderer.render(context);
    }

    public static Router delete(String uriTemplate, ContextHandler handler) {
        return DispatcherServlet.route().delete(uriTemplate, handler);
    }

    public static Router put(String uriTemplate, ContextHandler handler) {
        return DispatcherServlet.route().put(uriTemplate, handler);
    }

    public static Router get(String uriTemplate, ContextHandler handler) {
        return DispatcherServlet.route().get(uriTemplate, handler);
    }

    public static Router post(String uriTemplate, ContextHandler handler) {
        return DispatcherServlet.route().post(uriTemplate, handler);
    }

    public static Router route() {
        Router ret = new Router();
        routers.add(ret);
        return ret;
    }

    public static void mapping() {
        for (Router router : routers) {
            ContextHandlerMeta contextHandlerMeta = router.toContextHandlerMeta();
            RouteHandler.addContextHandlerMeta(contextHandlerMeta);
        }
    }

    static {
        HANDLERS.add(new RouteHandler());
        HANDLERS.add(new BeforeHandleHandler());
        HANDLERS.add(new ContextHandleHandler());
        HANDLERS.add(new AfterHandleHandler());
        routers = new ArrayList<Router>();
    }

    public static class Router {
        private List<String> uriTemplates = new ArrayList<String>();
        private List<HttpMethod> httpRequestMethods = new ArrayList<HttpMethod>();
        private ContextHandler handler;
        private Method method;

        public Router delete(String uriTemplate, ContextHandler handler) {
            return this.delete(new String[]{uriTemplate}, handler);
        }

        public Router delete(String[] uriTemplates, ContextHandler handler) {
            return this.delete().uris(uriTemplates).handler(handler);
        }

        public Router put(String uriTemplate, ContextHandler handler) {
            return this.put(new String[]{uriTemplate}, handler);
        }

        public Router put(String[] uriTemplates, ContextHandler handler) {
            return this.put().uris(uriTemplates).handler(handler);
        }

        public Router post(String uriTemplate, ContextHandler handler) {
            return this.post(new String[]{uriTemplate}, handler);
        }

        public Router post(String[] uriTemplates, ContextHandler handler) {
            return this.post().uris(uriTemplates).handler(handler);
        }

        public Router get(String uriTemplate, ContextHandler handler) {
            return this.get(new String[]{uriTemplate}, handler);
        }

        public Router get(String[] uriTemplates, ContextHandler handler) {
            return this.get().uris(uriTemplates).handler(handler);
        }

        public Router uris(String[] uriTemplates) {
            for (int i = 0; i < uriTemplates.length; ++i) {
                this.uri(uriTemplates[i]);
            }
            return this;
        }

        public Router uri(String uriTemplate) {
            if (!this.uriTemplates.contains(uriTemplate)) {
                this.uriTemplates.add(uriTemplate);
            }
            return this;
        }

        public Router get() {
            if (!this.httpRequestMethods.contains((Object)HttpMethod.GET)) {
                this.httpRequestMethods.add(HttpMethod.GET);
            }
            return this;
        }

        public Router post() {
            if (!this.httpRequestMethods.contains((Object)HttpMethod.POST)) {
                this.httpRequestMethods.add(HttpMethod.POST);
            }
            return this;
        }

        public Router delete() {
            if (!this.httpRequestMethods.contains((Object)HttpMethod.DELETE)) {
                this.httpRequestMethods.add(HttpMethod.DELETE);
            }
            return this;
        }

        public Router put() {
            if (!this.httpRequestMethods.contains((Object)HttpMethod.PUT)) {
                this.httpRequestMethods.add(HttpMethod.PUT);
            }
            return this;
        }

        public Router head() {
            if (!this.httpRequestMethods.contains((Object)HttpMethod.HEAD)) {
                this.httpRequestMethods.add(HttpMethod.HEAD);
            }
            return this;
        }

        public Router options() {
            if (!this.httpRequestMethods.contains((Object)HttpMethod.OPTIONS)) {
                this.httpRequestMethods.add(HttpMethod.OPTIONS);
            }
            return this;
        }

        public Router trace() {
            if (!this.httpRequestMethods.contains((Object)HttpMethod.TRACE)) {
                this.httpRequestMethods.add(HttpMethod.TRACE);
            }
            return this;
        }

        public Router handler(ContextHandler handler) {
            this.handler = handler;
            Class<?> clazz = handler.getClass();
            try {
                ContextHandler lambda = handler;
                Method m = clazz.getDeclaredMethod("writeReplace", new Class[0]);
                m.setAccessible(true);
                SerializedLambda sl = (SerializedLambda)m.invoke((Object)lambda, new Object[0]);
                String implClassName = sl.getImplClass().replaceAll("/", ".");
                Class<?> implClass = Class.forName(implClassName);
                this.method = implClass.getDeclaredMethod(sl.getImplMethodName(), RequestContext.class);
            }
            catch (Exception e) {
                LOGGER.log(Level.ERROR, "Found lambda method reference impl method failed", e);
            }
            return this;
        }

        ContextHandlerMeta toContextHandlerMeta() {
            ContextHandlerMeta ret = new ContextHandlerMeta();
            ret.setUriTemplates(this.uriTemplates.toArray(new String[0]));
            ret.setHttpMethods(this.httpRequestMethods.toArray(new HttpMethod[0]));
            ret.setInvokeHolder(this.method);
            ret.setHandler(this.handler);
            ret.initProcessAdvices();
            return ret;
        }
    }
}

