/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.servlet;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.servlet.handler.Handler;
import org.b3log.latke.servlet.renderer.AbstractResponseRenderer;
import org.b3log.latke.servlet.renderer.Http500Renderer;
import org.b3log.latke.servlet.renderer.JsonRenderer;
import org.b3log.latke.util.Requests;
import org.b3log.latke.util.URLs;
import org.json.JSONObject;

public final class RequestContext {
    private static final Logger LOGGER = Logger.getLogger(RequestContext.class);
    private HttpServletRequest request;
    private HttpServletResponse response;
    private JSONObject requestJSON;
    private AbstractResponseRenderer renderer;
    private Map<String, String> pathVars;
    private int handleIndex = -1;
    private List<Handler> handlers = new ArrayList<Handler>();

    public AbstractResponseRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(AbstractResponseRenderer renderer) {
        this.renderer = renderer;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public void setResponse(HttpServletResponse response) {
        this.response = response;
    }

    public Map<String, Object> getDataModel() {
        AbstractResponseRenderer renderer = this.getRenderer();
        if (null == renderer) {
            return null;
        }
        return renderer.getRenderDataModel();
    }

    public String remoteAddr() {
        return Requests.getRemoteAddr(this.request);
    }

    public void sendRedirect(String location) {
        try {
            this.response.sendRedirect(new URI(location).toASCIIString());
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Sends redirect [" + location + "] failed: " + e.getMessage(), new Object[0]);
        }
    }

    public String header(String name) {
        return this.request.getHeader(name);
    }

    public void addHeader(String name, String value) {
        this.response.addHeader(name, value);
    }

    public void setHeader(String name, String value) {
        this.response.setHeader(name, value);
    }

    public String queryStr() {
        return this.request.getQueryString();
    }

    public String method() {
        return this.request.getMethod();
    }

    public String requestURI() {
        return this.request.getRequestURI();
    }

    public Object attr(String name) {
        return this.request.getAttribute(name);
    }

    public void attr(String name, Object value) {
        this.request.setAttribute(name, value);
    }

    public String param(String name) {
        try {
            return this.request.getParameter(name);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Can't parse request parameter [uri=" + this.request.getRequestURI() + ", method=" + this.request.getMethod() + ", parameterName=" + name + "]: " + e.getMessage(), new Object[0]);
            return null;
        }
    }

    public String pathVar(String name) {
        return this.pathVars.get(name);
    }

    public Map<String, String> pathVars() {
        return this.pathVars;
    }

    public void pathVars(Map<String, String> pathVars) {
        this.pathVars = pathVars;
    }

    public void pathVar(String name, String value) {
        this.pathVars.put(name, value);
    }

    public void sendError(int sc) {
        try {
            this.response.sendError(sc);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Sends error status code [" + sc + "] failed: " + e.getMessage(), new Object[0]);
        }
    }

    public void setStatus(int sc) {
        try {
            this.response.setStatus(sc);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Sends status code [" + sc + "] failed: " + e.getMessage(), new Object[0]);
        }
    }

    public JSONObject requestJSON() {
        if (null == this.requestJSON) {
            this.requestJSON = RequestContext.parseRequestJSONObject(this.request, this.response);
        }
        return this.requestJSON;
    }

    public RequestContext renderJSONPretty(JSONObject json) {
        JsonRenderer jsonRenderer = new JsonRenderer();
        jsonRenderer.setJSONObject(json);
        jsonRenderer.setPretty(true);
        this.renderer = jsonRenderer;
        return this;
    }

    public RequestContext renderJSON() {
        JsonRenderer jsonRenderer = new JsonRenderer();
        JSONObject ret = new JSONObject().put("sc", false);
        jsonRenderer.setJSONObject(ret);
        this.renderer = jsonRenderer;
        return this;
    }

    public RequestContext renderJSON(JSONObject json) {
        JsonRenderer jsonRenderer = new JsonRenderer();
        jsonRenderer.setJSONObject(json);
        this.renderer = jsonRenderer;
        return this;
    }

    public RequestContext renderJSON(boolean sc) {
        JsonRenderer jsonRenderer = new JsonRenderer();
        JSONObject ret = new JSONObject().put("sc", sc);
        jsonRenderer.setJSONObject(ret);
        this.renderer = jsonRenderer;
        return this;
    }

    public RequestContext renderJSON(int code) {
        JsonRenderer jsonRenderer = new JsonRenderer();
        JSONObject ret = new JSONObject().put("code", code);
        jsonRenderer.setJSONObject(ret);
        this.renderer = jsonRenderer;
        return this;
    }

    public RequestContext renderTrueResult() {
        if (this.renderer instanceof JsonRenderer) {
            JsonRenderer r = (JsonRenderer)this.renderer;
            JSONObject ret = r.getJSONObject();
            ret.put("sc", true);
        }
        return this;
    }

    public RequestContext renderFalseResult() {
        if (this.renderer instanceof JsonRenderer) {
            JsonRenderer r = (JsonRenderer)this.renderer;
            JSONObject ret = r.getJSONObject();
            ret.put("sc", false);
        }
        return this;
    }

    public RequestContext renderCode(int code) {
        if (this.renderer instanceof JsonRenderer) {
            JsonRenderer r = (JsonRenderer)this.renderer;
            JSONObject ret = r.getJSONObject();
            ret.put("code", code);
        }
        return this;
    }

    public RequestContext renderMsg(String msg) {
        if (this.renderer instanceof JsonRenderer) {
            JsonRenderer r = (JsonRenderer)this.renderer;
            JSONObject ret = r.getJSONObject();
            ret.put("msg", msg);
        }
        return this;
    }

    public RequestContext renderData(Object data) {
        if (this.renderer instanceof JsonRenderer) {
            JsonRenderer r = (JsonRenderer)this.renderer;
            JSONObject ret = r.getJSONObject();
            ret.put("data", data);
        }
        return this;
    }

    public RequestContext renderPretty() {
        if (this.renderer instanceof JsonRenderer) {
            JsonRenderer r = (JsonRenderer)this.renderer;
            r.setPretty(true);
        }
        return this;
    }

    public RequestContext renderJSONValue(String name, Object obj) {
        if (this.renderer instanceof JsonRenderer) {
            JsonRenderer r = (JsonRenderer)this.renderer;
            JSONObject ret = r.getJSONObject();
            ret.put(name, obj);
        }
        return this;
    }

    public void handle() {
        try {
            ++this.handleIndex;
            while (this.handleIndex < this.handlers.size()) {
                this.handlers.get(this.handleIndex).handle(this);
                ++this.handleIndex;
            }
        }
        catch (Exception e) {
            String requestLog = Requests.getLog(this.request);
            LOGGER.log(Level.ERROR, "Handler process failed: " + requestLog, e);
            this.setRenderer(new Http500Renderer(e));
        }
    }

    public void abort() {
        this.handleIndex = 64;
    }

    public void addHandler(Handler handler) {
        this.handlers.add(handler);
    }

    private static JSONObject parseRequestJSONObject(HttpServletRequest request, HttpServletResponse response) {
        response.setContentType("application/json");
        try {
            BufferedReader reader;
            try {
                reader = request.getReader();
            }
            catch (IllegalStateException illegalStateException) {
                reader = new BufferedReader(new InputStreamReader((InputStream)request.getInputStream()));
            }
            String tmp = IOUtils.toString((Reader)reader);
            if (StringUtils.isBlank((String)tmp)) {
                tmp = "{}";
            } else if (StringUtils.startsWithIgnoreCase((String)tmp, (String)"%7B%22")) {
                tmp = URLs.decode(tmp);
            }
            return new JSONObject(tmp);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Parses request JSON object failed [" + e.getMessage() + "], returns an empty json object", new Object[0]);
            return new JSONObject();
        }
    }
}

