/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.servlet.handler;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.servlet.RequestContext;
import org.b3log.latke.servlet.advice.ProcessAdvice;
import org.b3log.latke.servlet.advice.RequestProcessAdviceException;
import org.b3log.latke.servlet.handler.ContextHandlerMeta;
import org.b3log.latke.servlet.handler.Handler;
import org.b3log.latke.servlet.handler.MatchResult;
import org.b3log.latke.servlet.renderer.AbstractResponseRenderer;
import org.b3log.latke.servlet.renderer.JsonRenderer;
import org.json.JSONObject;

public class BeforeHandleHandler
implements Handler {
    private static final Logger LOGGER = Logger.getLogger(BeforeHandleHandler.class);

    @Override
    public void handle(RequestContext context) throws Exception {
        MatchResult result = (MatchResult)context.attr("MATCH_RESULT");
        ContextHandlerMeta contextHandlerMeta = result.getContextHandlerMeta();
        List<AbstractResponseRenderer> rendererList = result.getRendererList();
        try {
            List<ProcessAdvice> beforeRequestProcessAdvices = contextHandlerMeta.getBeforeRequestProcessAdvices();
            for (ProcessAdvice beforeRequestProcessAdvice : beforeRequestProcessAdvices) {
                beforeRequestProcessAdvice.doAdvice(context);
            }
        }
        catch (RequestProcessAdviceException e) {
            JSONObject exception = e.getJsonObject();
            String msg = exception.optString("msg");
            LOGGER.log(Level.WARN, "Occurred an exception before request processing: " + msg, new Object[0]);
            int statusCode = exception.optInt("sc", -1);
            if (-1 != statusCode && 200 != statusCode) {
                HttpServletResponse response = context.getResponse();
                response.sendError(statusCode, msg);
            } else {
                JsonRenderer ret = new JsonRenderer();
                ret.setJSONObject(exception);
                context.setRenderer(ret);
            }
            context.abort();
            return;
        }
        for (AbstractResponseRenderer renderer : rendererList) {
            renderer.preRender(context);
        }
        context.handle();
    }
}

