/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.servlet.handler;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.b3log.latke.Latkes;
import org.b3log.latke.ioc.Bean;
import org.b3log.latke.ioc.BeanManager;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.servlet.HttpMethod;
import org.b3log.latke.servlet.RequestContext;
import org.b3log.latke.servlet.annotation.RequestProcessing;
import org.b3log.latke.servlet.annotation.RequestProcessor;
import org.b3log.latke.servlet.handler.ContextHandlerMeta;
import org.b3log.latke.servlet.handler.Handler;
import org.b3log.latke.servlet.handler.MatchResult;
import org.b3log.latke.util.UriTemplates;

public class RouteHandler
implements Handler {
    private static final Logger LOGGER = Logger.getLogger(RouteHandler.class);
    public static final String MATCH_RESULT = "MATCH_RESULT";
    private static final Map<String, ContextHandlerMeta> ONE_SEG_CONCRETE_CTX_HANDLER_METAS = new ConcurrentHashMap<String, ContextHandlerMeta>();
    private static final Map<String, ContextHandlerMeta> ONE_SEG_GET_VAR_CTX_HANDLER_METAS = new ConcurrentHashMap<String, ContextHandlerMeta>();
    private static final Map<String, ContextHandlerMeta> ONE_SEG_POST_VAR_CTX_HANDLER_METAS = new ConcurrentHashMap<String, ContextHandlerMeta>();
    private static final Map<String, ContextHandlerMeta> ONE_SEG_PUT_VAR_CTX_HANDLER_METAS = new ConcurrentHashMap<String, ContextHandlerMeta>();
    private static final Map<String, ContextHandlerMeta> ONE_SEG_DELETE_VAR_CTX_HANDLER_METAS = new ConcurrentHashMap<String, ContextHandlerMeta>();
    private static final Map<String, ContextHandlerMeta> ONE_SEG_OTHER_METHOD_VAR_CTX_HANDLER_METAS = new ConcurrentHashMap<String, ContextHandlerMeta>();
    private static final Map<String, ContextHandlerMeta> TWO_SEG_CONCRETE_CTX_HANDLER_METAS = new ConcurrentHashMap<String, ContextHandlerMeta>();
    private static final Map<String, ContextHandlerMeta> TWO_SEG_GET_VAR_CTX_HANDLER_METAS = new ConcurrentHashMap<String, ContextHandlerMeta>();
    private static final Map<String, ContextHandlerMeta> TWO_SEG_POST_VAR_CTX_HANDLER_METAS = new ConcurrentHashMap<String, ContextHandlerMeta>();
    private static final Map<String, ContextHandlerMeta> TWO_SEG_PUT_VAR_CTX_HANDLER_METAS = new ConcurrentHashMap<String, ContextHandlerMeta>();
    private static final Map<String, ContextHandlerMeta> TWO_SEG_DELETE_VAR_CTX_HANDLER_METAS = new ConcurrentHashMap<String, ContextHandlerMeta>();
    private static final Map<String, ContextHandlerMeta> TWO_SEG_OTHER_METHOD_VAR_CTX_HANDLER_METAS = new ConcurrentHashMap<String, ContextHandlerMeta>();
    private static final Map<String, ContextHandlerMeta> THREE_SEG_CONCRETE_CTX_HANDLER_METAS = new ConcurrentHashMap<String, ContextHandlerMeta>();
    private static final Map<String, ContextHandlerMeta> THREE_SEG_GET_VAR_CTX_HANDLER_METAS = new ConcurrentHashMap<String, ContextHandlerMeta>();
    private static final Map<String, ContextHandlerMeta> THREE_SEG_POST_VAR_CTX_HANDLER_METAS = new ConcurrentHashMap<String, ContextHandlerMeta>();
    private static final Map<String, ContextHandlerMeta> THREE_SEG_PUT_VAR_CTX_HANDLER_METAS = new ConcurrentHashMap<String, ContextHandlerMeta>();
    private static final Map<String, ContextHandlerMeta> THREE_SEG_DELETE_VAR_CTX_HANDLER_METAS = new ConcurrentHashMap<String, ContextHandlerMeta>();
    private static final Map<String, ContextHandlerMeta> THREE_SEG_OTHER_METHOD_VAR_CTX_HANDLER_METAS = new ConcurrentHashMap<String, ContextHandlerMeta>();
    private static final Map<String, ContextHandlerMeta> FOUR_MORE_SEG_CONCRETE_CTX_HANDLER_METAS = new ConcurrentHashMap<String, ContextHandlerMeta>();
    private static final Map<String, ContextHandlerMeta> FOUR_MORE_SEG_GET_VAR_CTX_HANDLER_METAS = new ConcurrentHashMap<String, ContextHandlerMeta>();
    private static final Map<String, ContextHandlerMeta> FOUR_MORE_SEG_POST_VAR_CTX_HANDLER_METAS = new ConcurrentHashMap<String, ContextHandlerMeta>();
    private static final Map<String, ContextHandlerMeta> FOUR_MORE_SEG_PUT_VAR_CTX_HANDLER_METAS = new ConcurrentHashMap<String, ContextHandlerMeta>();
    private static final Map<String, ContextHandlerMeta> FOUR_MORE_SEG_DELETE_VAR_CTX_HANDLER_METAS = new ConcurrentHashMap<String, ContextHandlerMeta>();
    private static final Map<String, ContextHandlerMeta> FOUR_MORE_SEG_OTHER_METHOD_VAR_CTX_HANDLER_METAS = new ConcurrentHashMap<String, ContextHandlerMeta>();

    public RouteHandler() {
        BeanManager beanManager = BeanManager.getInstance();
        Set<Bean<?>> processBeans = beanManager.getBeans(RequestProcessor.class);
        this.generateContextHandlerMeta(processBeans);
    }

    @Override
    public void handle(RequestContext context) {
        HttpServletRequest request = context.getRequest();
        long startTimeMillis = System.currentTimeMillis();
        request.setAttribute("startTimeMillis", (Object)startTimeMillis);
        String requestURI = this.getRequestURI(request);
        requestURI = StringUtils.substringAfter((String)requestURI, (String)Latkes.getContextPath());
        String httpMethod = this.getHttpMethod(request);
        LOGGER.log(Level.DEBUG, "Request [requestURI={0}, method={1}]", requestURI, httpMethod);
        MatchResult result = RouteHandler.doMatch(requestURI, httpMethod);
        if (result != null) {
            context.pathVars(result.getPathVars());
            context.attr(MATCH_RESULT, result);
            context.handle();
        }
        context.abort();
    }

    public static MatchResult doMatch(String requestURI, String httpMethod) {
        int segs = StringUtils.countMatches((String)requestURI, (String)"/");
        String concreteKey = httpMethod + "." + requestURI;
        switch (segs) {
            case 1: {
                ContextHandlerMeta contextHandlerMeta = ONE_SEG_CONCRETE_CTX_HANDLER_METAS.get(concreteKey);
                if (null != contextHandlerMeta) {
                    return new MatchResult(contextHandlerMeta, requestURI, httpMethod, requestURI);
                }
                switch (httpMethod) {
                    case "GET": {
                        return RouteHandler.route(requestURI, httpMethod, ONE_SEG_GET_VAR_CTX_HANDLER_METAS);
                    }
                    case "POST": {
                        return RouteHandler.route(requestURI, httpMethod, ONE_SEG_POST_VAR_CTX_HANDLER_METAS);
                    }
                    case "PUT": {
                        return RouteHandler.route(requestURI, httpMethod, ONE_SEG_PUT_VAR_CTX_HANDLER_METAS);
                    }
                    case "DELETE": {
                        return RouteHandler.route(requestURI, httpMethod, ONE_SEG_DELETE_VAR_CTX_HANDLER_METAS);
                    }
                }
                return RouteHandler.route(requestURI, httpMethod, ONE_SEG_OTHER_METHOD_VAR_CTX_HANDLER_METAS);
            }
            case 2: {
                ContextHandlerMeta contextHandlerMeta = TWO_SEG_CONCRETE_CTX_HANDLER_METAS.get(concreteKey);
                if (null != contextHandlerMeta) {
                    return new MatchResult(contextHandlerMeta, requestURI, httpMethod, requestURI);
                }
                switch (httpMethod) {
                    case "GET": {
                        return RouteHandler.route(requestURI, httpMethod, TWO_SEG_GET_VAR_CTX_HANDLER_METAS);
                    }
                    case "POST": {
                        return RouteHandler.route(requestURI, httpMethod, TWO_SEG_POST_VAR_CTX_HANDLER_METAS);
                    }
                    case "PUT": {
                        return RouteHandler.route(requestURI, httpMethod, TWO_SEG_PUT_VAR_CTX_HANDLER_METAS);
                    }
                    case "DELETE": {
                        return RouteHandler.route(requestURI, httpMethod, TWO_SEG_DELETE_VAR_CTX_HANDLER_METAS);
                    }
                }
                return RouteHandler.route(requestURI, httpMethod, TWO_SEG_OTHER_METHOD_VAR_CTX_HANDLER_METAS);
            }
            case 3: {
                ContextHandlerMeta contextHandlerMeta = THREE_SEG_CONCRETE_CTX_HANDLER_METAS.get(concreteKey);
                if (null != contextHandlerMeta) {
                    return new MatchResult(contextHandlerMeta, requestURI, httpMethod, requestURI);
                }
                switch (httpMethod) {
                    case "GET": {
                        return RouteHandler.route(requestURI, httpMethod, THREE_SEG_GET_VAR_CTX_HANDLER_METAS);
                    }
                    case "POST": {
                        return RouteHandler.route(requestURI, httpMethod, THREE_SEG_POST_VAR_CTX_HANDLER_METAS);
                    }
                    case "PUT": {
                        return RouteHandler.route(requestURI, httpMethod, THREE_SEG_PUT_VAR_CTX_HANDLER_METAS);
                    }
                    case "DELETE": {
                        return RouteHandler.route(requestURI, httpMethod, THREE_SEG_DELETE_VAR_CTX_HANDLER_METAS);
                    }
                }
                return RouteHandler.route(requestURI, httpMethod, THREE_SEG_OTHER_METHOD_VAR_CTX_HANDLER_METAS);
            }
        }
        ContextHandlerMeta contextHandlerMeta = FOUR_MORE_SEG_CONCRETE_CTX_HANDLER_METAS.get(concreteKey);
        if (null != contextHandlerMeta) {
            return new MatchResult(contextHandlerMeta, requestURI, httpMethod, requestURI);
        }
        switch (httpMethod) {
            case "GET": {
                return RouteHandler.route(requestURI, httpMethod, FOUR_MORE_SEG_GET_VAR_CTX_HANDLER_METAS);
            }
            case "POST": {
                return RouteHandler.route(requestURI, httpMethod, FOUR_MORE_SEG_POST_VAR_CTX_HANDLER_METAS);
            }
            case "PUT": {
                return RouteHandler.route(requestURI, httpMethod, FOUR_MORE_SEG_PUT_VAR_CTX_HANDLER_METAS);
            }
            case "DELETE": {
                return RouteHandler.route(requestURI, httpMethod, FOUR_MORE_SEG_DELETE_VAR_CTX_HANDLER_METAS);
            }
        }
        return RouteHandler.route(requestURI, httpMethod, FOUR_MORE_SEG_OTHER_METHOD_VAR_CTX_HANDLER_METAS);
    }

    public static void addContextHandlerMeta(ContextHandlerMeta contextHandlerMeta) {
        Class<?> parameterType;
        Class<?>[] parameterTypes;
        Class<?>[] exceptionTypes;
        Method invokeHolder = contextHandlerMeta.getInvokeHolder();
        Class<?> returnType = invokeHolder.getReturnType();
        String methodName = invokeHolder.getDeclaringClass().getName() + "#" + invokeHolder.getName();
        if (!Void.TYPE.equals(returnType)) {
            LOGGER.error("Handler method [" + methodName + "] must return void");
            System.exit(-1);
        }
        if (0 < (exceptionTypes = invokeHolder.getExceptionTypes()).length) {
            LOGGER.error("Handler method [" + methodName + "] can not throw exceptions");
            System.exit(-1);
        }
        if (1 != (parameterTypes = invokeHolder.getParameterTypes()).length) {
            LOGGER.error("Handler method [" + methodName + "] must have one parameter with type [RequestContext]");
            System.exit(-1);
        }
        if (!RequestContext.class.equals(parameterType = parameterTypes[0])) {
            LOGGER.error("Handler method [" + methodName + "] must have one parameter with type [RequestContext]");
            System.exit(-1);
        }
        HttpMethod[] httpMethods = contextHandlerMeta.getHttpMethods();
        for (int i = 0; i < httpMethods.length; ++i) {
            String httpMethod = httpMethods[i].name();
            String[] uriTemplates = contextHandlerMeta.getUriTemplates();
            block59: for (int j = 0; j < uriTemplates.length; ++j) {
                String uriTemplate = uriTemplates[j];
                String key = httpMethod + "." + uriTemplate;
                int segs = StringUtils.countMatches((String)uriTemplate, (String)"/");
                if (!StringUtils.contains((String)uriTemplate, (String)"{")) {
                    switch (segs) {
                        case 1: {
                            ONE_SEG_CONCRETE_CTX_HANDLER_METAS.put(key, contextHandlerMeta);
                            break;
                        }
                        case 2: {
                            TWO_SEG_CONCRETE_CTX_HANDLER_METAS.put(key, contextHandlerMeta);
                            break;
                        }
                        case 3: {
                            THREE_SEG_CONCRETE_CTX_HANDLER_METAS.put(key, contextHandlerMeta);
                            break;
                        }
                        default: {
                            FOUR_MORE_SEG_CONCRETE_CTX_HANDLER_METAS.put(key, contextHandlerMeta);
                            break;
                        }
                    }
                    continue;
                }
                switch (segs) {
                    case 1: {
                        switch (httpMethod) {
                            case "GET": {
                                ONE_SEG_GET_VAR_CTX_HANDLER_METAS.put(uriTemplate, contextHandlerMeta);
                                continue block59;
                            }
                            case "POST": {
                                ONE_SEG_POST_VAR_CTX_HANDLER_METAS.put(uriTemplate, contextHandlerMeta);
                                continue block59;
                            }
                            case "PUT": {
                                ONE_SEG_PUT_VAR_CTX_HANDLER_METAS.put(uriTemplate, contextHandlerMeta);
                                continue block59;
                            }
                            case "DELETE": {
                                ONE_SEG_DELETE_VAR_CTX_HANDLER_METAS.put(uriTemplate, contextHandlerMeta);
                                continue block59;
                            }
                        }
                        ONE_SEG_OTHER_METHOD_VAR_CTX_HANDLER_METAS.put(uriTemplate, contextHandlerMeta);
                        continue block59;
                    }
                    case 2: {
                        switch (httpMethod) {
                            case "GET": {
                                TWO_SEG_GET_VAR_CTX_HANDLER_METAS.put(uriTemplate, contextHandlerMeta);
                                continue block59;
                            }
                            case "POST": {
                                TWO_SEG_POST_VAR_CTX_HANDLER_METAS.put(uriTemplate, contextHandlerMeta);
                                continue block59;
                            }
                            case "PUT": {
                                TWO_SEG_PUT_VAR_CTX_HANDLER_METAS.put(uriTemplate, contextHandlerMeta);
                                continue block59;
                            }
                            case "DELETE": {
                                TWO_SEG_DELETE_VAR_CTX_HANDLER_METAS.put(uriTemplate, contextHandlerMeta);
                                continue block59;
                            }
                        }
                        TWO_SEG_OTHER_METHOD_VAR_CTX_HANDLER_METAS.put(uriTemplate, contextHandlerMeta);
                        continue block59;
                    }
                    case 3: {
                        switch (httpMethod) {
                            case "GET": {
                                THREE_SEG_GET_VAR_CTX_HANDLER_METAS.put(uriTemplate, contextHandlerMeta);
                                continue block59;
                            }
                            case "POST": {
                                THREE_SEG_POST_VAR_CTX_HANDLER_METAS.put(uriTemplate, contextHandlerMeta);
                                continue block59;
                            }
                            case "PUT": {
                                THREE_SEG_PUT_VAR_CTX_HANDLER_METAS.put(uriTemplate, contextHandlerMeta);
                                continue block59;
                            }
                            case "DELETE": {
                                THREE_SEG_DELETE_VAR_CTX_HANDLER_METAS.put(uriTemplate, contextHandlerMeta);
                                continue block59;
                            }
                        }
                        THREE_SEG_OTHER_METHOD_VAR_CTX_HANDLER_METAS.put(uriTemplate, contextHandlerMeta);
                        continue block59;
                    }
                    default: {
                        switch (httpMethod) {
                            case "GET": {
                                FOUR_MORE_SEG_GET_VAR_CTX_HANDLER_METAS.put(uriTemplate, contextHandlerMeta);
                                continue block59;
                            }
                            case "POST": {
                                FOUR_MORE_SEG_POST_VAR_CTX_HANDLER_METAS.put(uriTemplate, contextHandlerMeta);
                                continue block59;
                            }
                            case "PUT": {
                                FOUR_MORE_SEG_PUT_VAR_CTX_HANDLER_METAS.put(uriTemplate, contextHandlerMeta);
                                continue block59;
                            }
                            case "DELETE": {
                                FOUR_MORE_SEG_DELETE_VAR_CTX_HANDLER_METAS.put(uriTemplate, contextHandlerMeta);
                                continue block59;
                            }
                        }
                        FOUR_MORE_SEG_OTHER_METHOD_VAR_CTX_HANDLER_METAS.put(uriTemplate, contextHandlerMeta);
                    }
                }
            }
        }
        LOGGER.log(Level.DEBUG, "Added a processor method [" + methodName + "]", new Object[0]);
    }

    private static MatchResult route(String requestURI, String httpMethod, Map<String, ContextHandlerMeta> pathVarContextHandlerMetasHolder) {
        for (Map.Entry<String, ContextHandlerMeta> entry : pathVarContextHandlerMetasHolder.entrySet()) {
            String uriTemplate = entry.getKey();
            ContextHandlerMeta contextHandlerMeta = entry.getValue();
            Map<String, String> resolveResult = UriTemplates.resolve(requestURI, uriTemplate);
            if (null == resolveResult) continue;
            MatchResult ret = new MatchResult(contextHandlerMeta, requestURI, httpMethod, uriTemplate);
            ret.setPathVars(resolveResult);
            return ret;
        }
        return null;
    }

    private String getHttpMethod(HttpServletRequest request) {
        String ret = (String)request.getAttribute("requestMethod");
        if (StringUtils.isBlank((String)ret)) {
            ret = request.getMethod();
        }
        return ret;
    }

    private String getRequestURI(HttpServletRequest request) {
        String ret = (String)request.getAttribute("requestURI");
        if (StringUtils.isBlank((String)ret)) {
            ret = request.getRequestURI();
        }
        return ret;
    }

    private void generateContextHandlerMeta(Set<Bean<?>> processBeans) {
        for (Bean<?> latkeBean : processBeans) {
            Class<?> clz = latkeBean.getBeanClass();
            Method[] declaredMethods = clz.getDeclaredMethods();
            for (int i = 0; i < declaredMethods.length; ++i) {
                Method method = declaredMethods[i];
                RequestProcessing requestProcessingMethodAnn = method.getAnnotation(RequestProcessing.class);
                if (null == requestProcessingMethodAnn) continue;
                ContextHandlerMeta contextHandlerMeta = new ContextHandlerMeta();
                contextHandlerMeta.setUriTemplates(requestProcessingMethodAnn.value());
                contextHandlerMeta.setHttpMethods(requestProcessingMethodAnn.method());
                contextHandlerMeta.setInvokeHolder(method);
                contextHandlerMeta.initProcessAdvices();
                RouteHandler.addContextHandlerMeta(contextHandlerMeta);
            }
        }
    }
}

