/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.servlet.renderer;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletResponse;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.servlet.RequestContext;
import org.b3log.latke.servlet.renderer.AbstractResponseRenderer;
import org.json.JSONObject;

public final class JsonRenderer
extends AbstractResponseRenderer {
    private static final Logger LOGGER = Logger.getLogger(JsonRenderer.class);
    private boolean pretty;
    private JSONObject jsonObject;
    private boolean jsonp;
    private String callback = "callback";

    public boolean isPretty() {
        return this.pretty;
    }

    public void setPretty(boolean pretty) {
        this.pretty = pretty;
    }

    public JSONObject getJSONObject() {
        return this.jsonObject;
    }

    public void setJSONObject(JSONObject jsonObject) {
        this.jsonObject = jsonObject;
    }

    public boolean isJSONP() {
        return this.jsonp;
    }

    public JsonRenderer setJSONP(boolean isJSONP) {
        this.jsonp = isJSONP;
        return this;
    }

    public void setCallback(String callback) {
        this.callback = callback;
        this.setJSONP(true);
    }

    @Override
    public void render(RequestContext context) {
        HttpServletResponse response = context.getResponse();
        response.setCharacterEncoding("UTF-8");
        try {
            String output;
            PrintWriter writer = response.getWriter();
            int indent = 4;
            String string = output = this.pretty ? this.jsonObject.toString(4) : this.jsonObject.toString();
            if (!this.jsonp) {
                response.setContentType("application/json");
                writer.println(output);
            } else {
                response.setContentType("application/javascript");
                writer.print(this.callback + "(" + output + ")");
            }
            writer.close();
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "FreeMarker renders error", e);
            try {
                response.sendError(500);
            }
            catch (IOException ex) {
                LOGGER.log(Level.ERROR, "Can not send error 500!", ex);
            }
        }
    }
}

