/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.servlet.renderer;

import java.io.IOException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.servlet.RequestContext;
import org.b3log.latke.servlet.renderer.AbstractResponseRenderer;

public final class PngRenderer
extends AbstractResponseRenderer {
    private static final Logger LOGGER = Logger.getLogger(PngRenderer.class);
    private byte[] data;

    public void setImage(byte[] data) {
        this.data = data;
    }

    @Override
    public void render(RequestContext context) {
        try {
            HttpServletResponse response = context.getResponse();
            response.setContentType("image/png");
            ServletOutputStream outputStream = response.getOutputStream();
            outputStream.write(this.data);
            outputStream.close();
        }
        catch (IOException e) {
            LOGGER.log(Level.ERROR, "Render PNG failed", e);
        }
    }
}

