/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.servlet.renderer;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletResponse;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.servlet.RequestContext;
import org.b3log.latke.servlet.renderer.AbstractResponseRenderer;

public final class TextHtmlRenderer
extends AbstractResponseRenderer {
    private static final Logger LOGGER = Logger.getLogger(TextHtmlRenderer.class);
    private String content;

    public void setContent(String content) {
        this.content = content;
    }

    @Override
    public void render(RequestContext context) {
        try {
            HttpServletResponse response = context.getResponse();
            response.setContentType("text/html");
            response.setCharacterEncoding("UTF-8");
            PrintWriter writer = response.getWriter();
            writer.write(this.content);
            writer.close();
        }
        catch (IOException e) {
            LOGGER.log(Level.ERROR, "Render failed", e);
        }
    }
}

