/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;

public final class AntPathMatcher {
    private static final String DEFAULT_PATH_SEPARATOR = "/";
    private static final String pathSeparator = "/";

    public static boolean isPattern(String path) {
        return path.indexOf(42) != -1 || path.indexOf(63) != -1;
    }

    public static boolean match(String pattern, String path) {
        return AntPathMatcher.doMatch(pattern, path, true);
    }

    public static boolean matchStart(String pattern, String path) {
        return AntPathMatcher.doMatch(pattern, path, false);
    }

    protected static boolean doMatch(String pattern, String path, boolean fullMatch) {
        String patDir;
        int pathIdxStart;
        if (path.startsWith("/") != pattern.startsWith("/")) {
            return false;
        }
        String[] pattDirs = AntPathMatcher.tokenizeToStringArray(pattern, "/");
        String[] pathDirs = AntPathMatcher.tokenizeToStringArray(path, "/");
        int pattIdxStart = 0;
        int pattIdxEnd = pattDirs.length - 1;
        int pathIdxEnd = pathDirs.length - 1;
        for (pathIdxStart = 0; pattIdxStart <= pattIdxEnd && pathIdxStart <= pathIdxEnd && !"**".equals(patDir = pattDirs[pattIdxStart]); ++pattIdxStart, ++pathIdxStart) {
            if (AntPathMatcher.matchStrings(patDir, pathDirs[pathIdxStart])) continue;
            return false;
        }
        if (pathIdxStart > pathIdxEnd) {
            if (pattIdxStart > pattIdxEnd) {
                return pattern.endsWith("/") ? path.endsWith("/") : !path.endsWith("/");
            }
            if (!fullMatch) {
                return true;
            }
            if (pattIdxStart == pattIdxEnd && pattDirs[pattIdxStart].equals("*") && path.endsWith("/")) {
                return true;
            }
            for (int i = pattIdxStart; i <= pattIdxEnd; ++i) {
                if (pattDirs[i].equals("**")) continue;
                return false;
            }
            return true;
        }
        if (pattIdxStart > pattIdxEnd) {
            return false;
        }
        if (!fullMatch && "**".equals(pattDirs[pattIdxStart])) {
            return true;
        }
        while (pattIdxStart <= pattIdxEnd && pathIdxStart <= pathIdxEnd && !(patDir = pattDirs[pattIdxEnd]).equals("**")) {
            if (!AntPathMatcher.matchStrings(patDir, pathDirs[pathIdxEnd])) {
                return false;
            }
            --pattIdxEnd;
            --pathIdxEnd;
        }
        if (pathIdxStart > pathIdxEnd) {
            for (int i = pattIdxStart; i <= pattIdxEnd; ++i) {
                if (pattDirs[i].equals("**")) continue;
                return false;
            }
            return true;
        }
        while (pattIdxStart != pattIdxEnd && pathIdxStart <= pathIdxEnd) {
            int patIdxTmp = -1;
            for (int i = pattIdxStart + 1; i <= pattIdxEnd; ++i) {
                if (!pattDirs[i].equals("**")) continue;
                patIdxTmp = i;
                break;
            }
            if (patIdxTmp == pattIdxStart + 1) {
                ++pattIdxStart;
                continue;
            }
            int patLength = patIdxTmp - pattIdxStart - 1;
            int strLength = pathIdxEnd - pathIdxStart + 1;
            int foundIdx = -1;
            block6: for (int i = 0; i <= strLength - patLength; ++i) {
                for (int j = 0; j < patLength; ++j) {
                    String subPat = pattDirs[pattIdxStart + j + 1];
                    String subStr = pathDirs[pathIdxStart + i + j];
                    if (!AntPathMatcher.matchStrings(subPat, subStr)) continue block6;
                }
                foundIdx = pathIdxStart + i;
                break;
            }
            if (foundIdx == -1) {
                return false;
            }
            pattIdxStart = patIdxTmp;
            pathIdxStart = foundIdx + patLength;
        }
        for (int i = pattIdxStart; i <= pattIdxEnd; ++i) {
            if (pattDirs[i].equals("**")) continue;
            return false;
        }
        return true;
    }

    private static boolean matchStrings(String pattern, String str) {
        char ch;
        int i;
        char[] patArr = pattern.toCharArray();
        char[] strArr = str.toCharArray();
        int patIdxStart = 0;
        int patIdxEnd = patArr.length - 1;
        int strIdxStart = 0;
        int strIdxEnd = strArr.length - 1;
        boolean containsStar = false;
        for (i = 0; i < patArr.length; ++i) {
            if (patArr[i] != '*') continue;
            containsStar = true;
            break;
        }
        if (!containsStar) {
            if (patIdxEnd != strIdxEnd) {
                return false;
            }
            for (i = 0; i <= patIdxEnd; ++i) {
                char ch2 = patArr[i];
                if (ch2 == '?' || ch2 == strArr[i]) continue;
                return false;
            }
            return true;
        }
        if (patIdxEnd == 0) {
            return true;
        }
        while ((ch = patArr[patIdxStart]) != '*' && strIdxStart <= strIdxEnd) {
            if (ch != '?' && ch != strArr[strIdxStart]) {
                return false;
            }
            ++patIdxStart;
            ++strIdxStart;
        }
        if (strIdxStart > strIdxEnd) {
            for (i = patIdxStart; i <= patIdxEnd; ++i) {
                if (patArr[i] == '*') continue;
                return false;
            }
            return true;
        }
        while ((ch = patArr[patIdxEnd]) != '*' && strIdxStart <= strIdxEnd) {
            if (ch != '?' && ch != strArr[strIdxEnd]) {
                return false;
            }
            --patIdxEnd;
            --strIdxEnd;
        }
        if (strIdxStart > strIdxEnd) {
            for (i = patIdxStart; i <= patIdxEnd; ++i) {
                if (patArr[i] == '*') continue;
                return false;
            }
            return true;
        }
        while (patIdxStart != patIdxEnd && strIdxStart <= strIdxEnd) {
            int patIdxTmp = -1;
            for (int i2 = patIdxStart + 1; i2 <= patIdxEnd; ++i2) {
                if (patArr[i2] != '*') continue;
                patIdxTmp = i2;
                break;
            }
            if (patIdxTmp == patIdxStart + 1) {
                ++patIdxStart;
                continue;
            }
            int patLength = patIdxTmp - patIdxStart - 1;
            int strLength = strIdxEnd - strIdxStart + 1;
            int foundIdx = -1;
            block8: for (int i3 = 0; i3 <= strLength - patLength; ++i3) {
                for (int j = 0; j < patLength; ++j) {
                    ch = patArr[patIdxStart + j + 1];
                    if (ch != '?' && ch != strArr[strIdxStart + i3 + j]) continue block8;
                }
                foundIdx = strIdxStart + i3;
                break;
            }
            if (foundIdx == -1) {
                return false;
            }
            patIdxStart = patIdxTmp;
            strIdxStart = foundIdx + patLength;
        }
        for (i = patIdxStart; i <= patIdxEnd; ++i) {
            if (patArr[i] == '*') continue;
            return false;
        }
        return true;
    }

    public String extractPathWithinPattern(String pattern, String path) {
        int i;
        String[] patternParts = AntPathMatcher.tokenizeToStringArray(pattern, "/");
        String[] pathParts = AntPathMatcher.tokenizeToStringArray(path, "/");
        StringBuffer buffer = new StringBuffer();
        int puts = 0;
        for (i = 0; i < patternParts.length; ++i) {
            String patternPart = patternParts[i];
            if (patternPart.indexOf(42) <= -1 && patternPart.indexOf(63) <= -1 || pathParts.length < i + 1) continue;
            if (puts > 0 || i == 0 && !pattern.startsWith("/")) {
                buffer.append("/");
            }
            buffer.append(pathParts[i]);
            ++puts;
        }
        for (i = patternParts.length; i < pathParts.length; ++i) {
            if (puts > 0 || i > 0) {
                buffer.append("/");
            }
            buffer.append(pathParts[i]);
        }
        return buffer.toString();
    }

    private static String[] tokenizeToStringArray(String str, String delimiters) {
        if (null == str) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(str, delimiters);
        ArrayList<String> tokens = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if ((token = token.trim()).length() <= 0) continue;
            tokens.add(token);
        }
        return AntPathMatcher.toStringArray(tokens);
    }

    private static String[] toStringArray(Collection collection) {
        if (null == collection) {
            return null;
        }
        return collection.toArray(new String[collection.size()]);
    }
}

