/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.util;

import org.apache.commons.lang.StringUtils;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.util.Strings;

public final class Callstacks {
    private static final Logger LOGGER = Logger.getLogger(Callstacks.class);

    public static boolean isCaller(String className, String methodName) {
        Throwable throwable = new Throwable();
        StackTraceElement[] stackElements = throwable.getStackTrace();
        if (null == stackElements) {
            LOGGER.log(Level.WARN, "Empty call stack", new Object[0]);
            return false;
        }
        boolean matchAllMethod = "*".equals(methodName);
        for (int i = 1; i < stackElements.length; ++i) {
            if (!stackElements[i].getClassName().equals(className)) continue;
            return matchAllMethod ? true : stackElements[i].getMethodName().equals(methodName);
        }
        return false;
    }

    public static void printCallstack(Level logLevel, String[] carePackages, String[] exceptablePackages) {
        if (null == logLevel) {
            LOGGER.log(Level.WARN, "Requires parameter [logLevel]", new Object[0]);
            return;
        }
        Throwable throwable = new Throwable();
        StackTraceElement[] stackElements = throwable.getStackTrace();
        if (null == stackElements) {
            LOGGER.log(Level.WARN, "Empty call stack", new Object[0]);
            return;
        }
        long tId = Thread.currentThread().getId();
        StringBuilder stackBuilder = new StringBuilder("CallStack [tId=").append(tId).append(Strings.LINE_SEPARATOR);
        for (int i = 1; i < stackElements.length; ++i) {
            String stackElemClassName = stackElements[i].getClassName();
            if (!StringUtils.startsWithAny((String)stackElemClassName, (String[])carePackages) || StringUtils.startsWithAny((String)stackElemClassName, (String[])exceptablePackages)) continue;
            stackBuilder.append("    [className=").append(stackElements[i].getClassName()).append(", fileName=").append(stackElements[i].getFileName()).append(", lineNumber=").append(stackElements[i].getLineNumber()).append(", methodName=").append(stackElements[i].getMethodName()).append(']').append(Strings.LINE_SEPARATOR);
        }
        stackBuilder.append("], full depth [").append(stackElements.length).append("]");
        LOGGER.log(logLevel, stackBuilder.toString(), new Object[0]);
    }

    private Callstacks() {
    }
}

