/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.util;

import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;

public final class Crypts {
    private static final Logger LOGGER = Logger.getLogger(Crypts.class);

    public static String signHmacSHA1(String source, String secret) {
        try {
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(new SecretKeySpec(secret.getBytes(StandardCharsets.UTF_8), "HmacSHA1"));
            byte[] signData = mac.doFinal(source.getBytes(StandardCharsets.UTF_8));
            return new String(Base64.encodeBase64((byte[])signData), StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new RuntimeException("HMAC-SHA1 sign failed", e);
        }
    }

    public static String encryptByAES(String content, String key) {
        try {
            KeyGenerator kgen = KeyGenerator.getInstance("AES");
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            secureRandom.setSeed(key.getBytes());
            kgen.init(128, secureRandom);
            SecretKey secretKey = kgen.generateKey();
            byte[] enCodeFormat = secretKey.getEncoded();
            SecretKeySpec keySpec = new SecretKeySpec(enCodeFormat, "AES");
            Cipher cipher = Cipher.getInstance("AES");
            byte[] byteContent = content.getBytes(StandardCharsets.UTF_8);
            cipher.init(1, keySpec);
            byte[] result = cipher.doFinal(byteContent);
            return Hex.encodeHexString((byte[])result);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARN, "Encrypt failed", e);
            return null;
        }
    }

    public static String decryptByAES(String content, String key) {
        try {
            byte[] data = Hex.decodeHex((char[])content.toCharArray());
            KeyGenerator kgen = KeyGenerator.getInstance("AES");
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            secureRandom.setSeed(key.getBytes());
            kgen.init(128, secureRandom);
            SecretKey secretKey = kgen.generateKey();
            byte[] enCodeFormat = secretKey.getEncoded();
            SecretKeySpec keySpec = new SecretKeySpec(enCodeFormat, "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(2, keySpec);
            byte[] result = cipher.doFinal(data);
            return new String(result, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARN, "Decrypt failed", new Object[0]);
            return null;
        }
    }

    private Crypts() {
    }
}

