/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.util;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.b3log.latke.Latkes;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;

public final class Locales {
    private static final Logger LOGGER = Logger.getLogger(Locales.class);
    private static final ThreadLocal<Locale> LOCALE = new InheritableThreadLocal<Locale>();
    private static final int LANG_START = 0;
    private static final int LANG_END = 2;
    private static final int COUNTRY_START = 3;
    private static final int COUNTRY_END = 5;

    private Locales() {
    }

    public static Locale getLocale(HttpServletRequest request) {
        Locale locale = null;
        HttpSession session = request.getSession(false);
        if (session != null) {
            locale = (Locale)session.getAttribute("locale");
        }
        if (null == locale) {
            String languageHeader = request.getHeader("Accept-Language");
            LOGGER.log(Level.DEBUG, "[Accept-Language={0}]", languageHeader);
            String language = "zh";
            String country = "CN";
            if (StringUtils.isNotBlank((String)languageHeader)) {
                language = Locales.getLanguage(languageHeader);
                country = Locales.getCountry(languageHeader);
            }
            if (!Locales.hasLocale(locale = new Locale(language, country))) {
                locale = Latkes.getLocale();
                LOGGER.log(Level.DEBUG, "Using the default locale[{0}]", locale.toString());
            } else {
                LOGGER.log(Level.DEBUG, "Got locale[{0}] from request.", locale.toString());
            }
        } else {
            LOGGER.log(Level.DEBUG, "Got locale[{0}] from session.", locale.toString());
        }
        return locale;
    }

    public static boolean hasLocale(Locale locale) {
        try {
            ResourceBundle.getBundle("lang", locale);
            return true;
        }
        catch (MissingResourceException e) {
            return false;
        }
    }

    public static void setLocale(HttpServletRequest request, Locale locale) {
        HttpSession session = request.getSession(false);
        if (null == session) {
            LOGGER.warn("Ignores set locale caused by no session");
            return;
        }
        session.setAttribute("locale", (Object)locale);
        LOGGER.log(Level.DEBUG, "Client[sessionId={0}] sets locale to [{1}]", session.getId(), locale.toString());
    }

    public static void setLocale(Locale locale) {
        LOCALE.set(locale);
    }

    public static Locale getLocale() {
        Locale ret = LOCALE.get();
        if (null == ret) {
            return Latkes.getLocale();
        }
        return ret;
    }

    public static String getCountry(String localeString) {
        if (localeString.length() >= 5) {
            return localeString.substring(3, 5);
        }
        return "";
    }

    public static String getLanguage(String localeString) {
        if (localeString.length() >= 2) {
            return localeString.substring(0, 2);
        }
        return "";
    }

    public static Locale getLocale(String localeString) {
        String language = Locales.getLanguage(localeString);
        String country = Locales.getCountry(localeString);
        return new Locale(language, country);
    }
}

