/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.util;

import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Enumeration;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.util.Strings;
import org.json.JSONArray;

public final class Requests {
    private static final int COOKIE_EXPIRY = 86400;

    public static void log(HttpServletRequest httpServletRequest, Level level, Logger logger) {
        if (!logger.isLoggable(level)) {
            return;
        }
        logger.log(level, Requests.getLog(httpServletRequest), new Object[0]);
    }

    public static String getLog(HttpServletRequest httpServletRequest) {
        if (null == httpServletRequest) {
            return "request is null";
        }
        String indents = "    ";
        StringBuilder logBuilder = new StringBuilder("Request [").append(Strings.LINE_SEPARATOR);
        logBuilder.append("    ").append("method=").append(httpServletRequest.getMethod()).append(",").append(Strings.LINE_SEPARATOR);
        logBuilder.append("    ").append("URL=").append(httpServletRequest.getRequestURL()).append(",").append(Strings.LINE_SEPARATOR);
        logBuilder.append("    ").append("contentType=").append(httpServletRequest.getContentType()).append(",").append(Strings.LINE_SEPARATOR);
        logBuilder.append("    ").append("characterEncoding=").append(httpServletRequest.getCharacterEncoding()).append(",").append(Strings.LINE_SEPARATOR);
        logBuilder.append("    ").append("local=[").append(Strings.LINE_SEPARATOR);
        logBuilder.append("    ").append("    ").append("addr=").append(httpServletRequest.getLocalAddr()).append(",").append(Strings.LINE_SEPARATOR);
        logBuilder.append("    ").append("    ").append("port=").append(httpServletRequest.getLocalPort()).append(",").append(Strings.LINE_SEPARATOR);
        logBuilder.append("    ").append("    ").append("name=").append(httpServletRequest.getLocalName()).append("],").append(Strings.LINE_SEPARATOR);
        logBuilder.append("    ").append("remote=[").append(Strings.LINE_SEPARATOR);
        logBuilder.append("    ").append("    ").append("addr=").append(Requests.getRemoteAddr(httpServletRequest)).append(",").append(Strings.LINE_SEPARATOR);
        logBuilder.append("    ").append("    ").append("port=").append(httpServletRequest.getRemotePort()).append(",").append(Strings.LINE_SEPARATOR);
        logBuilder.append("    ").append("    ").append("host=").append(httpServletRequest.getRemoteHost()).append("],").append(Strings.LINE_SEPARATOR);
        logBuilder.append("    ").append("headers=[");
        Enumeration headerNames = httpServletRequest.getHeaderNames();
        StringBuilder headerLogBuilder = new StringBuilder();
        if (null != headerNames) {
            logBuilder.append(Strings.LINE_SEPARATOR);
            while (headerNames.hasMoreElements()) {
                String name = (String)headerNames.nextElement();
                String value = httpServletRequest.getHeader(name);
                headerLogBuilder.append("    ").append("    ").append(name).append("=").append(value);
                headerLogBuilder.append(Strings.LINE_SEPARATOR);
            }
            headerLogBuilder.append("    ");
        }
        headerLogBuilder.append("]");
        logBuilder.append(headerLogBuilder.toString());
        logBuilder.append(Strings.LINE_SEPARATOR).append("]");
        return logBuilder.toString();
    }

    public static String getRemoteAddr(HttpServletRequest request) {
        String ret = request.getHeader("X-Forwarded-For");
        if (StringUtils.isBlank((String)ret) && StringUtils.isBlank((String)(ret = request.getHeader("X-Real-IP")))) {
            return request.getRemoteAddr();
        }
        return ret.split(",")[0];
    }

    public static String getServerScheme(HttpServletRequest request) {
        String ret = request.getHeader("X-Forwarded-Scheme");
        if (StringUtils.isBlank((String)ret) && StringUtils.isBlank((String)(ret = request.getHeader("X-Forwarded-Proto")))) {
            return request.getScheme();
        }
        return ret;
    }

    public static String getServerName(HttpServletRequest request) {
        String ret = request.getHeader("X-Forwarded-Host");
        if (StringUtils.isBlank((String)ret)) {
            return request.getServerName();
        }
        return ret;
    }

    public static boolean hasBeenServed(HttpServletRequest request, HttpServletResponse response) {
        Cookie[] cookies = request.getCookies();
        if (null == cookies || 0 == cookies.length) {
            return false;
        }
        boolean needToCreate = true;
        boolean needToAppend = true;
        JSONArray cookieJSONArray = null;
        try {
            for (int i = 0; i < cookies.length; ++i) {
                Cookie cookie = cookies[i];
                if (!"visited".equals(cookie.getName())) continue;
                String value = URLDecoder.decode(cookie.getValue(), "UTF-8");
                cookieJSONArray = new JSONArray(value);
                if (null == cookieJSONArray || 0 == cookieJSONArray.length()) {
                    return false;
                }
                needToCreate = false;
                for (int j = 0; j < cookieJSONArray.length(); ++j) {
                    String visitedURL = cookieJSONArray.optString(j);
                    if (!request.getRequestURI().equals(visitedURL)) continue;
                    needToAppend = false;
                    return true;
                }
            }
            if (needToCreate) {
                StringBuilder builder = new StringBuilder("[").append("\"").append(request.getRequestURI()).append("\"]");
                Cookie c = new Cookie("visited", URLEncoder.encode(builder.toString(), "UTF-8"));
                c.setMaxAge(86400);
                c.setPath("/");
                response.addCookie(c);
            } else if (needToAppend) {
                cookieJSONArray.put(request.getRequestURI());
                Cookie c = new Cookie("visited", URLEncoder.encode(cookieJSONArray.toString(), "UTF-8"));
                c.setMaxAge(86400);
                c.setPath("/");
                response.addCookie(c);
            }
        }
        catch (Exception e) {
            Cookie c = new Cookie("visited", null);
            c.setMaxAge(0);
            c.setPath("/");
            response.addCookie(c);
        }
        return false;
    }

    private Requests() {
    }
}

