/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.util;

import java.io.File;
import java.net.URI;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang.StringUtils;
import org.b3log.latke.Latkes;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.util.AntPathMatcher;
import org.b3log.latke.util.Strings;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class StaticResources {
    private static final Logger LOGGER = Logger.getLogger(StaticResources.class);
    private static final Set<String> STATIC_RESOURCE_PATHS = new TreeSet<String>();
    private static boolean inited;

    public static boolean isStatic(HttpServletRequest request) {
        boolean requestStaticResourceChecked;
        boolean bl = requestStaticResourceChecked = null == request.getAttribute("requestStaticResourceChecked") ? false : (Boolean)request.getAttribute("requestStaticResourceChecked");
        if (requestStaticResourceChecked) {
            return (Boolean)request.getAttribute("isRequestStaticResource");
        }
        if (!inited) {
            StaticResources.init();
        }
        request.setAttribute("requestStaticResourceChecked", (Object)true);
        request.setAttribute("isRequestStaticResource", (Object)false);
        String requestURI = request.getRequestURI();
        for (String pattern : STATIC_RESOURCE_PATHS) {
            if (!AntPathMatcher.match(Latkes.getContextPath() + pattern, requestURI)) continue;
            request.setAttribute("isRequestStaticResource", (Object)true);
            return true;
        }
        return false;
    }

    private static synchronized void init() {
        LOGGER.trace("Reads static resources definition from [static-resources.xml]");
        File staticResources = Latkes.getWebFile("/WEB-INF/static-resources.xml");
        if (null == staticResources || !staticResources.exists()) {
            throw new IllegalStateException("Not found static resources definition from [static-resources.xml]");
        }
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(staticResources);
            Element root = document.getDocumentElement();
            root.normalize();
            StringBuilder logBuilder = new StringBuilder("Reading static files: [").append(Strings.LINE_SEPARATOR);
            NodeList includes = root.getElementsByTagName("include");
            for (int i = 0; i < includes.getLength(); ++i) {
                Element include = (Element)includes.item(i);
                String path = include.getAttribute("path");
                URI uri = new URI("http", "b3log.org", path, null);
                String s = uri.toASCIIString();
                path = StringUtils.substringAfter((String)s, (String)"b3log.org");
                STATIC_RESOURCE_PATHS.add(path);
                logBuilder.append("    ").append("path pattern [").append(path).append("]");
                if (i < includes.getLength() - 1) {
                    logBuilder.append(",");
                }
                logBuilder.append(Strings.LINE_SEPARATOR);
            }
            logBuilder.append("]");
            if (LOGGER.isTraceEnabled()) {
                LOGGER.debug(logBuilder.toString());
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Reads [" + staticResources.getName() + "] failed", e);
            throw new RuntimeException(e);
        }
        StringBuilder logBuilder = new StringBuilder("Static files: [").append(Strings.LINE_SEPARATOR);
        Iterator<String> iterator = STATIC_RESOURCE_PATHS.iterator();
        while (iterator.hasNext()) {
            String pattern = iterator.next();
            logBuilder.append("    ").append(pattern);
            if (iterator.hasNext()) {
                logBuilder.append(',');
            }
            logBuilder.append(Strings.LINE_SEPARATOR);
        }
        logBuilder.append("], ").append('[').append(STATIC_RESOURCE_PATHS.size()).append("] path patterns");
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(logBuilder.toString());
        }
        inited = true;
    }

    private StaticResources() {
    }
}

