/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.util;

import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.b3log.latke.ioc.BeanManager;
import org.b3log.latke.service.LangPropsService;

public final class Times {
    private static final long MINUTE_UNIT = 60000L;
    private static final long HOUR_UNIT = 3600000L;
    private static final long DAY_UNIT = 86400000L;
    private static final long WEEK_UNIT = 604800000L;
    private static final long MONTH_UNIT = 2678400000L;
    private static final long YEAR_UNIT = 32140800000L;

    public static String getTimeAgo(long time, Locale locale) {
        BeanManager beanManager = BeanManager.getInstance();
        LangPropsService langService = beanManager.getReference(LangPropsService.class);
        Map<String, String> langs = langService.getAll(locale);
        long diff = System.currentTimeMillis() - time;
        if (diff > 32140800000L) {
            long r = diff / 32140800000L;
            return r + " " + langs.get("yearsAgoLabel");
        }
        if (diff > 2678400000L) {
            long r = diff / 2678400000L;
            return r + " " + langs.get("monthsAgoLabel");
        }
        if (diff > 604800000L) {
            long r = diff / 604800000L;
            return r + " " + langs.get("weeksAgoLabel");
        }
        if (diff > 86400000L) {
            long r = diff / 86400000L;
            return r + " " + langs.get("daysAgoLabel");
        }
        if (diff > 3600000L) {
            long r = diff / 3600000L;
            return r + " " + langs.get("hoursAgoLabel");
        }
        if (diff > 60000L) {
            long r = diff / 60000L;
            return r + " " + langs.get("minutesAgoLabel");
        }
        return langs.get("justNowLabel");
    }

    public static boolean isSameDay(Date date1, Date date2) {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date1);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(date2);
        return cal1.get(0) == cal2.get(0) && cal1.get(1) == cal2.get(1) && cal1.get(2) == cal2.get(2) && cal1.get(5) == cal2.get(5);
    }

    public static boolean isSameWeek(Date date1, Date date2) {
        Calendar cal1 = Calendar.getInstance();
        cal1.setFirstDayOfWeek(2);
        cal1.setTime(date1);
        Calendar cal2 = Calendar.getInstance();
        cal2.setFirstDayOfWeek(2);
        cal2.setTime(date2);
        return cal1.get(0) == cal2.get(0) && cal1.get(1) == cal2.get(1) && cal1.get(3) == cal2.get(3);
    }

    public static boolean isSameMonth(Date date1, Date date2) {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date1);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(date2);
        return cal1.get(0) == cal2.get(0) && cal1.get(1) == cal2.get(1) && cal1.get(2) == cal2.get(2);
    }

    public static long getDayStartTime(long time) {
        Calendar start = Calendar.getInstance();
        start.setTimeInMillis(time);
        int year = start.get(1);
        int month = start.get(2);
        int day = start.get(5);
        start.set(year, month, day, 0, 0, 0);
        start.set(14, 0);
        return start.getTimeInMillis();
    }

    public static long getDayEndTime(long time) {
        Calendar end = Calendar.getInstance();
        end.setTimeInMillis(time);
        int year = end.get(1);
        int month = end.get(2);
        int day = end.get(5);
        end.set(year, month, day, 23, 59, 59);
        end.set(14, 999);
        return end.getTimeInMillis();
    }

    public static int getWeekDay(long time) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(time);
        int ret = calendar.get(7) - 1;
        if (ret <= 0) {
            ret = 7;
        }
        return ret;
    }

    public static long getWeekStartTime(long time) {
        Calendar start = Calendar.getInstance();
        start.setFirstDayOfWeek(2);
        start.setTimeInMillis(time);
        start.set(7, 2);
        start.set(10, 0);
        start.set(12, 0);
        start.set(13, 0);
        start.set(14, 0);
        return start.getTimeInMillis();
    }

    public static long getWeekEndTime(long time) {
        Calendar end = Calendar.getInstance();
        end.setFirstDayOfWeek(2);
        end.setTimeInMillis(time);
        end.set(7, 1);
        end.set(10, 23);
        end.set(12, 59);
        end.set(13, 59);
        end.set(14, 999);
        return end.getTimeInMillis();
    }

    public static long getMonthStartTime(long time) {
        Calendar start = Calendar.getInstance();
        start.setTimeInMillis(time);
        int year = start.get(1);
        int month = start.get(2);
        start.set(year, month, 1, 0, 0, 0);
        start.set(14, 0);
        return start.getTimeInMillis();
    }

    public static long getMonthEndTime(long time) {
        Calendar end = Calendar.getInstance();
        end.setTimeInMillis(Times.getDayStartTime(time));
        end.set(5, end.getActualMaximum(5));
        end.set(10, 23);
        end.set(12, 59);
        end.set(13, 59);
        end.set(14, 999);
        return end.getTimeInMillis();
    }

    private Times() {
    }
}

