<#--

    Bolo - A stable and beautiful blogging system based in Solo.
    Copyright (c) 2020, https://github.com/adlered

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.

-->
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1" />
    <meta name="viewport" content='width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0, shrink-to-fit=no' name='viewport' />
    <link href="https://cnxiaobai.com/bolo/start/css/font.css" rel="stylesheet" />
    <link rel="stylesheet" href="https://cdn.staticfile.org/font-awesome/4.7.0/css/font-awesome.min.css" />
    <link href="https://cnxiaobai.com/bolo/start/css/bootstrap.min.css" rel="stylesheet" />
    <link href="https://cnxiaobai.com/bolo/start/css/now-ui-kit.css?v=1.1.0" rel="stylesheet" />
    <link href="https://cnxiaobai.com/bolo/start/css/demo.css" rel="stylesheet" />
    <link rel="icon" type="image/png" href="${faviconURL}"/>
    <link rel="apple-touch-icon" href="${faviconURL}">
    <link rel="shortcut icon" type="image/x-icon" href="${faviconURL}">
    <title>管理登录</title>
</head>

<body class="login-page sidebar-collapse">
<nav class="navbar navbar-expand-lg bg-primary fixed-top navbar-transparent" color-on-scroll="400">
    <div class="container">
        <div class="collapse navbar-collapse justify-content-start">
            <ul class="navbar-nav">
                <li class="nav-item">
                    <a class="nav-link" rel="tooltip" title="返回主页" data-placement="bottom" href="${staticServePath}/">
                        <i class="fa fa-home"></i>
                        <p class="d-lg-none d-xl-none">返回主页</p>
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" rel="tooltip" title="开源驱动：菠萝博客" data-placement="bottom" href="https://github.com/adlered/bolo-solo" target="_blank">
                        <i class="fa fa-github"></i>
                        <p class="d-lg-none d-xl-none">Bolo on GitHub</p>
                    </a>
                </li>
            </ul>
        </div>
    </div>
</nav>
<div class="page-header" filter-color="orange">
    <div class="page-header-image" id="bgHeader"></div>
    <div class="container">
        <div class="col-md-4 content-center">
            <div class="card card-login card-plain">
                <form class="form" action="${servePath}/oauth/bolo/login" method="POST" id="loginForm">
                    <div class="content">
                        <div class="input-group form-group-no-border input-lg">
                                <span class="input-group-addon" style="padding-right: 12px;">
                                    <i class="fa fa-user-circle-o"></i>
                                </span>
                            <input type="text" id="username" name="username" class="form-control" placeholder="管理员用户名" />
                        </div>
                        <div class="input-group form-group-no-border input-lg">
                                <span class="input-group-addon" style="padding-right: 12px;">
                                    <i class="fa fa-key"></i>
                                </span>
                            <input type="password" id="password" name="password" class="form-control" placeholder="管理员密码"  />
                        </div>
                    </div>
                    <div class="footer text-center">
                        <button class="btn btn-primary btn-round btn-lg btn-block" id="loginBtn" type="button">${loginLabel}</button>
                    </div>
                </form>
                <span id="status"></span>
            </div>
        </div>
    </div>
    <script>
        status = '${data}';
        if (status === '2') {
            document.getElementsByTagName("title")[0].innerText = '快速迁移到 Bolo';
            document.getElementById('status').innerHTML = '检测到您是Solo用户 ❤️<br>请按照以下步骤进行快速迁移：<br><b>1. 备份您的数据库</b><br><b>2. 在上方填写您想设定的管理员用户名和密码</b><br><b>3. 点击开始迁移按钮，稍等片刻即可</b>';
            document.getElementById('loginBtn').innerHTML = '开始迁移';
            document.getElementsByClassName("navbar")[0].remove();
            setTimeout(function () {
                document.getElementsByClassName("footer")[1].remove();
            }, 1000);
            document.getElementById('loginBtn').onclick = function () {
                if (document.getElementById('username').value !== '' && document.getElementById('password').value !== '') {
                    let pwdRegex = new RegExp('(?=.*[0-9])(?=.*[a-zA-Z]).{8,30}');
                    if (!pwdRegex.test(document.getElementById('password').value)) {
                        alert("密码强度过低！请使用8-30位密码，必须包含字母和数字。");
                    } else {
                        document.getElementById('loginBtn').innerHTML = '<i class="fa fa-spinner fa-pulse"></i> 正在快速迁移中，请稍候';
                        document.getElementById('loginForm').submit();
                    }
                } else {
                    alert('请填写用户名和密码！');
                }
            }
        } else {
            if (status === '0') {
                document.getElementById('status').innerHTML = '用户名或密码错误';
            }
            if (status === '-1') {
                document.getElementsByTagName("title")[0].innerText = '欢迎使用 Bolo';
                document.getElementById('status').innerHTML = '部署成功！欢迎使用菠萝博客 ❤️<br>您的博客尚未初始化<br>请在输入框中设定管理后台用户名和密码<br>点击“开始初始化”按钮初始化你的菠萝博客';
                document.getElementById('loginBtn').innerHTML = '开始初始化';
                document.getElementById('password').setAttribute("type", "text");
            }
            document.getElementById('loginBtn').onclick = function () {
                if (document.getElementById('username').value !== '' && document.getElementById('password').value !== '') {
                    if (status === '-1') {
                        let pwdRegex = new RegExp('(?=.*[0-9])(?=.*[a-zA-Z]).{8,30}');
                        if (!pwdRegex.test(document.getElementById('password').value)) {
                            alert("密码强度过低！请使用8-30位密码，必须包含字母和数字。");
                        } else {
                            document.getElementById('loginBtn').innerHTML = '<i class="fa fa-spinner fa-pulse"></i> 正在初始化，请稍候';
                            document.getElementById('loginForm').submit();
                        }
                    } else {
                        document.getElementById('loginBtn').innerHTML = '<i class="fa fa-spinner fa-pulse"></i> 登录中';
                        document.getElementById('loginForm').submit();
                    }
                } else {
                    document.getElementById('status').innerHTML = '请填写用户名和密码！';
                }
            }
        }
    </script>
    <footer class="footer">
        <div class="container">
            <div class="copyright">
                <span id="description"></span>
            </div>
        </div>
    </footer>
</div>
</body>
<script src="https://cnxiaobai.com/bolo/start/js/core/jquery.3.2.1.min.js" type="text/javascript"></script>
<script src="https://cnxiaobai.com/bolo/start/js/core/popper.min.js" type="text/javascript"></script>
<script src="https://cnxiaobai.com/bolo/start/js/core/bootstrap.min.js" type="text/javascript"></script>
<script src="https://cnxiaobai.com/bolo/start/js/plugins/bootstrap-switch.js"></script>
<script src="https://cnxiaobai.com/bolo/start/js/plugins/nouislider.min.js" type="text/javascript"></script>
<script src="https://cnxiaobai.com/bolo/start/js/plugins/bootstrap-datepicker.js" type="text/javascript"></script>
<script src="https://cnxiaobai.com/bolo/start/js/plugins/jquery.sharrre.js" type="text/javascript"></script>
<script src="https://cnxiaobai.com/bolo/start/js/now-ui-kit.js?v=1.1.0" type="text/javascript"></script>
<script type="text/javascript">
    $('#description').load('https://cnxiaobai.com/bolo/description.htm');
    $('#bgHeader').prop('style', 'background-image:url("https://cnxiaobai.com/bolo/bg.png")');
</script>
</html>