/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.aspect;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import run.halo.app.annotation.DisableOnCondition;
import run.halo.app.config.properties.HaloProperties;
import run.halo.app.exception.ForbiddenException;
import run.halo.app.model.enums.Mode;

@Aspect
@Component
public class DisableOnConditionAspect {
    private static final Logger log = LoggerFactory.getLogger(DisableOnConditionAspect.class);
    private final HaloProperties haloProperties;

    public DisableOnConditionAspect(HaloProperties haloProperties) {
        this.haloProperties = haloProperties;
    }

    @Pointcut(value="within(run.halo.app.controller..*)")
    public void pointcut() {
    }

    @Around(value="pointcut() && @annotation(disableApi)")
    public Object around(ProceedingJoinPoint joinPoint, DisableOnCondition disableApi) throws Throwable {
        Mode mode = disableApi.mode();
        if (this.haloProperties.getMode().equals((Object)mode)) {
            throw new ForbiddenException("\u7981\u6b62\u8bbf\u95ee");
        }
        return joinPoint.proceed();
    }
}

