/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.cache;

import java.util.Date;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import run.halo.app.cache.CacheStore;
import run.halo.app.cache.CacheWrapper;
import run.halo.app.config.properties.HaloProperties;
import run.halo.app.utils.DateUtils;

public abstract class AbstractCacheStore<K, V>
implements CacheStore<K, V> {
    private static final Logger log = LoggerFactory.getLogger(AbstractCacheStore.class);
    protected HaloProperties haloProperties;

    @NonNull
    abstract Optional<CacheWrapper<V>> getInternal(@NonNull K var1);

    abstract void putInternal(@NonNull K var1, @NonNull CacheWrapper<V> var2);

    abstract Boolean putInternalIfAbsent(@NonNull K var1, @NonNull CacheWrapper<V> var2);

    public Optional<V> get(K key) {
        Assert.notNull(key, (String)"Cache key must not be blank");
        return this.getInternal(key).map(cacheWrapper -> {
            if (cacheWrapper.getExpireAt() != null && cacheWrapper.getExpireAt().before(DateUtils.now())) {
                log.warn("Cache key: [{}] has been expired", key);
                this.delete(key);
                return null;
            }
            return cacheWrapper.getData();
        });
    }

    public void put(K key, V value, long timeout, TimeUnit timeUnit) {
        this.putInternal(key, this.buildCacheWrapper(value, timeout, timeUnit));
    }

    public void put(K key, V value) {
        this.putInternal(key, this.buildCacheWrapper(value, 0L, null));
    }

    public Boolean putIfAbsent(K key, V value, long timeout, TimeUnit timeUnit) {
        return this.putInternalIfAbsent(key, this.buildCacheWrapper(value, timeout, timeUnit));
    }

    @NonNull
    private CacheWrapper<V> buildCacheWrapper(@NonNull V value, long timeout, @Nullable TimeUnit timeUnit) {
        Assert.notNull(value, (String)"Cache value must not be null");
        Assert.isTrue((timeout >= 0L ? 1 : 0) != 0, (String)"Cache expiration timeout must not be less than 1");
        Date now = DateUtils.now();
        Date expireAt = null;
        if (timeout > 0L && timeUnit != null) {
            expireAt = DateUtils.add((Date)now, (long)timeout, (TimeUnit)timeUnit);
        }
        CacheWrapper cacheWrapper = new CacheWrapper();
        cacheWrapper.setCreateAt(now);
        cacheWrapper.setExpireAt(expireAt);
        cacheWrapper.setData(value);
        return cacheWrapper;
    }
}

