/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.cache;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import run.halo.app.cache.AbstractCacheStore;
import run.halo.app.cache.CacheWrapper;
import run.halo.app.exception.ServiceException;
import run.halo.app.utils.JsonUtils;

public abstract class AbstractStringCacheStore
extends AbstractCacheStore<String, String> {
    private static final Logger log = LoggerFactory.getLogger(AbstractStringCacheStore.class);

    protected Optional<CacheWrapper<String>> jsonToCacheWrapper(String json) {
        if (!StringUtils.hasText((String)json)) {
            return Optional.empty();
        }
        CacheWrapper cacheWrapper = null;
        try {
            cacheWrapper = (CacheWrapper)JsonUtils.jsonToObject((String)json, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Exception e) {
            log.debug("Failed to convert json to wrapper value bytes: [{}]", (Object)json, (Object)e);
        }
        return Optional.ofNullable(cacheWrapper);
    }

    public <T> void putAny(String key, T value) {
        try {
            this.put((Object)key, (Object)JsonUtils.objectToJson(value));
        }
        catch (JsonProcessingException e) {
            throw new ServiceException("Failed to convert " + value + " to json", (Throwable)e);
        }
    }

    public <T> void putAny(@NonNull String key, @NonNull T value, long timeout, @NonNull TimeUnit timeUnit) {
        try {
            this.put((Object)key, (Object)JsonUtils.objectToJson(value), timeout, timeUnit);
        }
        catch (JsonProcessingException e) {
            throw new ServiceException("Failed to convert " + value + " to json", (Throwable)e);
        }
    }

    public <T> Optional<T> getAny(String key, Class<T> type) {
        Assert.notNull(type, (String)"Type must not be null");
        return this.get((Object)key).map(value -> {
            try {
                return JsonUtils.jsonToObject((String)value, (Class)type);
            }
            catch (IOException e) {
                log.error("Failed to convert json to type: " + type.getName(), (Throwable)e);
                return null;
            }
        });
    }
}

