/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.cache;

import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import run.halo.app.cache.AbstractStringCacheStore;
import run.halo.app.cache.CacheWrapper;
import run.halo.app.cache.InMemoryCacheStore;

public class InMemoryCacheStore
extends AbstractStringCacheStore {
    private static final Logger log = LoggerFactory.getLogger(InMemoryCacheStore.class);
    private static final long PERIOD = 60000L;
    private static final ConcurrentHashMap<String, CacheWrapper<String>> CACHE_CONTAINER = new ConcurrentHashMap();
    private final Timer timer;
    private final Lock lock = new ReentrantLock();

    public InMemoryCacheStore() {
        this.timer = new Timer();
        this.timer.scheduleAtFixedRate((TimerTask)new CacheExpiryCleaner(this), 0L, 60000L);
    }

    @NonNull
    Optional<CacheWrapper<String>> getInternal(@NonNull String key) {
        Assert.hasText((String)key, (String)"Cache key must not be blank");
        return Optional.ofNullable((CacheWrapper)CACHE_CONTAINER.get(key));
    }

    void putInternal(@NonNull String key, @NonNull CacheWrapper<String> cacheWrapper) {
        Assert.hasText((String)key, (String)"Cache key must not be blank");
        Assert.notNull(cacheWrapper, (String)"Cache wrapper must not be null");
        CacheWrapper<String> putCacheWrapper = CACHE_CONTAINER.put(key, cacheWrapper);
        log.debug("Put [{}] cache result: [{}], original cache wrapper: [{}]", new Object[]{key, putCacheWrapper, cacheWrapper});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Boolean putInternalIfAbsent(@NonNull String key, @NonNull CacheWrapper<String> cacheWrapper) {
        Assert.hasText((String)key, (String)"Cache key must not be blank");
        Assert.notNull(cacheWrapper, (String)"Cache wrapper must not be null");
        log.debug("Preparing to put key: [{}], value: [{}]", (Object)key, cacheWrapper);
        this.lock.lock();
        try {
            Optional valueOptional = this.get((Object)key);
            if (valueOptional.isPresent()) {
                log.warn("Failed to put the cache, because the key: [{}] has been present already", (Object)key);
                Boolean bl = false;
                return bl;
            }
            this.putInternal(key, cacheWrapper);
            log.debug("Put successfully");
            Boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void delete(@NonNull String key) {
        Assert.hasText((String)key, (String)"Cache key must not be blank");
        CACHE_CONTAINER.remove(key);
        log.debug("Removed key: [{}]", (Object)key);
    }

    public LinkedHashMap<String, String> toMap() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        CACHE_CONTAINER.forEach((key, value) -> map.put((String)key, (String)value.getData()));
        return map;
    }

    @PreDestroy
    public void preDestroy() {
        log.debug("Cancelling all timer tasks");
        this.timer.cancel();
        this.clear();
    }

    public void clear() {
        CACHE_CONTAINER.clear();
    }
}

