/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.cache;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.Options;
import org.iq80.leveldb.impl.Iq80DBFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import run.halo.app.cache.AbstractStringCacheStore;
import run.halo.app.cache.CacheWrapper;
import run.halo.app.cache.LevelCacheStore;
import run.halo.app.config.properties.HaloProperties;
import run.halo.app.utils.JsonUtils;

public class LevelCacheStore
extends AbstractStringCacheStore {
    private static final Logger log = LoggerFactory.getLogger(LevelCacheStore.class);
    private static final long PERIOD = 60000L;
    private static DB LEVEL_DB;
    private Timer timer;

    public LevelCacheStore(HaloProperties haloProperties) {
        this.haloProperties = haloProperties;
    }

    @PostConstruct
    public void init() {
        if (LEVEL_DB != null) {
            return;
        }
        try {
            File folder = new File(this.haloProperties.getWorkDir() + ".leveldb");
            Iq80DBFactory factory = new Iq80DBFactory();
            Options options = new Options();
            options.createIfMissing(true);
            LEVEL_DB = factory.open(folder, options);
            this.timer = new Timer();
            this.timer.scheduleAtFixedRate((TimerTask)new CacheExpiryCleaner(this), 0L, 60000L);
        }
        catch (Exception ex) {
            log.error("init leveldb error ", (Throwable)ex);
        }
    }

    @PreDestroy
    public void preDestroy() {
        try {
            LEVEL_DB.close();
            this.timer.cancel();
        }
        catch (IOException e) {
            log.error("close leveldb error ", (Throwable)e);
        }
    }

    @NonNull
    Optional<CacheWrapper<String>> getInternal(@NonNull String key) {
        Assert.hasText((String)key, (String)"Cache key must not be blank");
        byte[] bytes = LEVEL_DB.get(this.stringToBytes(key));
        if (bytes != null) {
            String valueJson = this.bytesToString(bytes);
            return StringUtils.isEmpty((Object)valueJson) ? Optional.empty() : this.jsonToCacheWrapper(valueJson);
        }
        return Optional.empty();
    }

    void putInternal(@NonNull String key, @NonNull CacheWrapper<String> cacheWrapper) {
        this.putInternalIfAbsent(key, cacheWrapper);
    }

    Boolean putInternalIfAbsent(@NonNull String key, @NonNull CacheWrapper<String> cacheWrapper) {
        Assert.hasText((String)key, (String)"Cache key must not be blank");
        Assert.notNull(cacheWrapper, (String)"Cache wrapper must not be null");
        try {
            LEVEL_DB.put(this.stringToBytes(key), this.stringToBytes(JsonUtils.objectToJson(cacheWrapper)));
            return true;
        }
        catch (JsonProcessingException e) {
            log.warn("Put cache fail json2object key: [{}] value:[{}]", (Object)key, cacheWrapper);
            log.debug("Cache key: [{}], original cache wrapper: [{}]", (Object)key, cacheWrapper);
            return false;
        }
    }

    public void delete(@NonNull String key) {
        LEVEL_DB.delete(this.stringToBytes(key));
        log.debug("cache remove key: [{}]", (Object)key);
    }

    public LinkedHashMap<String, String> toMap() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        LEVEL_DB.forEach(entry -> {
            String key = this.bytesToString((byte[])entry.getKey());
            String valueJson = this.bytesToString((byte[])entry.getValue());
            Optional cacheWrapperOptional = this.jsonToCacheWrapper(valueJson);
            if (cacheWrapperOptional.isPresent()) {
                map.put(key, (String)((CacheWrapper)cacheWrapperOptional.get()).getData());
            } else {
                map.put(key, null);
            }
        });
        return map;
    }

    private byte[] stringToBytes(String str) {
        return str.getBytes(Charset.defaultCharset());
    }

    private String bytesToString(byte[] bytes) {
        return new String(bytes, Charset.defaultCharset());
    }
}

