/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.cache;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import run.halo.app.cache.AbstractStringCacheStore;
import run.halo.app.cache.CacheWrapper;

public class RedisCacheStore
extends AbstractStringCacheStore {
    private static final Logger log = LoggerFactory.getLogger(RedisCacheStore.class);
    private static final String REDIS_PREFIX = "halo.redis.";
    private final StringRedisTemplate redisTemplate;

    public RedisCacheStore(StringRedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    @NonNull
    Optional<CacheWrapper<String>> getInternal(@NonNull String key) {
        Assert.hasText((String)key, (String)"Cache key must not be blank");
        String value = (String)this.redisTemplate.opsForValue().get((Object)(REDIS_PREFIX + key));
        CacheWrapper cacheStore = new CacheWrapper();
        cacheStore.setData((Object)value);
        return Optional.of(cacheStore);
    }

    void putInternal(@NonNull String key, @NonNull CacheWrapper<String> cacheWrapper) {
        Assert.hasText((String)key, (String)"Cache key must not be blank");
        Assert.notNull(cacheWrapper, (String)"Cache wrapper must not be null");
        if (cacheWrapper.getExpireAt() != null) {
            long expire = cacheWrapper.getExpireAt().getTime() - System.currentTimeMillis();
            this.redisTemplate.opsForValue().set((Object)(REDIS_PREFIX + key), (Object)((String)cacheWrapper.getData()), expire, TimeUnit.MILLISECONDS);
        } else {
            this.redisTemplate.opsForValue().set((Object)(REDIS_PREFIX + key), (Object)((String)cacheWrapper.getData()));
        }
        log.debug("Put [{}] cache : [{}]", (Object)key, cacheWrapper);
    }

    Boolean putInternalIfAbsent(@NonNull String key, @NonNull CacheWrapper<String> cacheWrapper) {
        Assert.hasText((String)key, (String)"Cache key must not be blank");
        Assert.notNull(cacheWrapper, (String)"Cache wrapper must not be null");
        log.debug("Preparing to put key: [{}], value: [{}]", (Object)key, cacheWrapper);
        if (Boolean.TRUE.equals(this.redisTemplate.hasKey((Object)key))) {
            log.warn("Failed to put the cache, the key: [{}] has been present already", (Object)key);
            return false;
        }
        this.putInternal(key, cacheWrapper);
        log.debug("Put successfully");
        return true;
    }

    public Optional<String> get(String key) {
        Assert.notNull((Object)key, (String)"Cache key must not be blank");
        return this.getInternal(key).map(CacheWrapper::getData);
    }

    public void delete(@NonNull String key) {
        Assert.hasText((String)key, (String)"Cache key must not be blank");
        if (Boolean.TRUE.equals(this.redisTemplate.hasKey((Object)(REDIS_PREFIX + key)))) {
            this.redisTemplate.delete((Object)(REDIS_PREFIX + key));
            log.debug("Removed key: [{}]", (Object)key);
        }
    }

    public LinkedHashMap<String, String> toMap() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        Set keys = this.redisTemplate.keys((Object)"halo.redis.*");
        if (CollectionUtils.isEmpty((Collection)keys)) {
            return map;
        }
        keys.forEach(key -> map.put((String)key, (String)this.redisTemplate.opsForValue().get(key)));
        return map;
    }

    @PreDestroy
    public void preDestroy() {
    }
}

