/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.cache.lock;

import java.lang.annotation.Annotation;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import run.halo.app.cache.AbstractStringCacheStore;
import run.halo.app.cache.lock.CacheLock;
import run.halo.app.cache.lock.CacheParam;
import run.halo.app.exception.FrequentAccessException;
import run.halo.app.exception.ServiceException;
import run.halo.app.utils.ServletUtils;

@Aspect
@Configuration
public class CacheLockInterceptor {
    private static final Logger log = LoggerFactory.getLogger(CacheLockInterceptor.class);
    private static final String CACHE_LOCK_PREFIX = "cache_lock_";
    private static final String CACHE_LOCK_VALUE = "locked";
    private final AbstractStringCacheStore cacheStore;

    public CacheLockInterceptor(AbstractStringCacheStore cacheStore) {
        this.cacheStore = cacheStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="@annotation(run.halo.app.cache.lock.CacheLock)")
    public Object interceptCacheLock(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        log.debug("Starting locking: [{}]", (Object)methodSignature.toString());
        CacheLock cacheLock = methodSignature.getMethod().getAnnotation(CacheLock.class);
        String cacheLockKey = this.buildCacheLockKey(cacheLock, joinPoint);
        log.debug("Built lock key: [{}]", (Object)cacheLockKey);
        try {
            Boolean cacheResult = this.cacheStore.putIfAbsent((Object)cacheLockKey, (Object)CACHE_LOCK_VALUE, cacheLock.expired(), cacheLock.timeUnit());
            if (cacheResult == null) {
                throw new ServiceException("Unknown reason of cache " + cacheLockKey).setErrorData((Object)cacheLockKey);
            }
            if (!cacheResult.booleanValue()) {
                throw new FrequentAccessException("\u8bbf\u95ee\u8fc7\u4e8e\u9891\u7e41\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01").setErrorData((Object)cacheLockKey);
            }
            Object object = joinPoint.proceed();
            return object;
        }
        finally {
            if (cacheLock.autoDelete()) {
                this.cacheStore.delete((Object)cacheLockKey);
                log.debug("Deleted the cache lock: [{}]", (Object)cacheLock);
            }
        }
    }

    private String buildCacheLockKey(@NonNull CacheLock cacheLock, @NonNull ProceedingJoinPoint joinPoint) {
        Assert.notNull((Object)cacheLock, (String)"Cache lock must not be null");
        Assert.notNull((Object)joinPoint, (String)"Proceeding join point must not be null");
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        StringBuilder cacheKeyBuilder = new StringBuilder(CACHE_LOCK_PREFIX);
        String delimiter = cacheLock.delimiter();
        if (StringUtils.isNotBlank((CharSequence)cacheLock.prefix())) {
            cacheKeyBuilder.append(cacheLock.prefix());
        } else {
            cacheKeyBuilder.append(methodSignature.getMethod().toString());
        }
        Annotation[][] parameterAnnotations = methodSignature.getMethod().getParameterAnnotations();
        for (int i = 0; i < parameterAnnotations.length; ++i) {
            log.debug("Parameter annotation[{}] = {}", (Object)i, (Object)parameterAnnotations[i]);
            for (int j = 0; j < parameterAnnotations[i].length; ++j) {
                Annotation annotation = parameterAnnotations[i][j];
                log.debug("Parameter annotation[{}][{}]: {}", new Object[]{i, j, annotation});
                if (!(annotation instanceof CacheParam)) continue;
                Object arg = joinPoint.getArgs()[i];
                log.debug("Cache param args: [{}]", arg);
                cacheKeyBuilder.append(delimiter).append(arg.toString());
            }
        }
        if (cacheLock.traceRequest()) {
            cacheKeyBuilder.append(delimiter).append(ServletUtils.getRequestIp());
        }
        return cacheKeyBuilder.toString();
    }
}

