/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.config;

import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import freemarker.template.TemplateModel;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.MultipartConfigElement;
import kr.pe.kwonnam.freemarker.inheritance.BlockDirective;
import kr.pe.kwonnam.freemarker.inheritance.PutDirective;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.servlet.MultipartAutoConfiguration;
import org.springframework.boot.autoconfigure.web.servlet.MultipartProperties;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcRegistrations;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.jackson.JsonComponentModule;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.ConverterFactory;
import org.springframework.core.io.FileUrlResource;
import org.springframework.core.io.Resource;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.web.PageableHandlerMethodArgumentResolver;
import org.springframework.data.web.SortHandlerMethodArgumentResolver;
import org.springframework.format.FormatterRegistry;
import org.springframework.http.CacheControl;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.util.StringUtils;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.multipart.MultipartResolver;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import run.halo.app.config.HaloMvcConfiguration;
import run.halo.app.config.properties.HaloProperties;
import run.halo.app.core.PageJacksonSerializer;
import run.halo.app.core.freemarker.inheritance.ThemeExtendsDirective;
import run.halo.app.factory.StringToEnumConverterFactory;
import run.halo.app.model.support.HaloConst;
import run.halo.app.security.resolver.AuthenticationArgumentResolver;
import run.halo.app.utils.HaloUtils;

@Configuration
@EnableConfigurationProperties(value={MultipartProperties.class})
@ImportAutoConfiguration(exclude={MultipartAutoConfiguration.class})
public class HaloMvcConfiguration
implements WebMvcConfigurer {
    private static final Logger log = LoggerFactory.getLogger(HaloMvcConfiguration.class);
    private static final String FILE_PROTOCOL = "file:///";
    private final PageableHandlerMethodArgumentResolver pageableResolver;
    private final SortHandlerMethodArgumentResolver sortResolver;
    private final HaloProperties haloProperties;
    @Value(value="${springfox.documentation.swagger-ui.base-url:}")
    private String swaggerBaseUrl;

    public HaloMvcConfiguration(PageableHandlerMethodArgumentResolver pageableResolver, SortHandlerMethodArgumentResolver sortResolver, HaloProperties haloProperties) {
        this.pageableResolver = pageableResolver;
        this.sortResolver = sortResolver;
        this.haloProperties = haloProperties;
    }

    public Map<String, TemplateModel> freemarkerLayoutDirectives() {
        HashMap<String, TemplateModel> freemarkerLayoutDirectives = new HashMap<String, TemplateModel>();
        freemarkerLayoutDirectives.put("extends", (TemplateModel)new ThemeExtendsDirective());
        freemarkerLayoutDirectives.put("block", (TemplateModel)new BlockDirective());
        freemarkerLayoutDirectives.put("put", (TemplateModel)new PutDirective());
        return freemarkerLayoutDirectives;
    }

    @Bean(name={"multipartResolver"})
    @ConditionalOnProperty(prefix="spring.servlet.multipart", name={"enabled"}, havingValue="true", matchIfMissing=true)
    MultipartResolver multipartResolver(MultipartProperties multipartProperties) throws IOException {
        MultipartConfigElement multipartConfigElement = multipartProperties.createMultipartConfig();
        1 resolver = new /* Unavailable Anonymous Inner Class!! */;
        resolver.setDefaultEncoding("UTF-8");
        resolver.setMaxUploadSize(multipartConfigElement.getMaxRequestSize());
        resolver.setMaxUploadSizePerFile(multipartConfigElement.getMaxFileSize());
        String location = multipartProperties.getLocation();
        if (StringUtils.hasText((String)location)) {
            FileUrlResource resource = new FileUrlResource(location);
            resolver.setUploadTempDir((Resource)resource);
        }
        resolver.setResolveLazily(multipartProperties.isResolveLazily());
        return resolver;
    }

    @Bean
    WebMvcRegistrations webMvcRegistrations() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public void extendMessageConverters(List<HttpMessageConverter<?>> converters) {
        converters.stream().filter(c -> c instanceof MappingJackson2HttpMessageConverter).findFirst().ifPresent(converter -> {
            MappingJackson2HttpMessageConverter mappingJackson2HttpMessageConverter = (MappingJackson2HttpMessageConverter)converter;
            Jackson2ObjectMapperBuilder builder = Jackson2ObjectMapperBuilder.json();
            JsonComponentModule module = new JsonComponentModule();
            module.addSerializer(PageImpl.class, (JsonSerializer)new PageJacksonSerializer());
            ObjectMapper objectMapper = builder.modules(new Module[]{module}).build();
            mappingJackson2HttpMessageConverter.setObjectMapper(objectMapper);
        });
    }

    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> resolvers) {
        resolvers.add((HandlerMethodArgumentResolver)new AuthenticationArgumentResolver());
        resolvers.add((HandlerMethodArgumentResolver)this.pageableResolver);
        resolvers.add((HandlerMethodArgumentResolver)this.sortResolver);
    }

    public void addViewControllers(ViewControllerRegistry registry) {
        registry.addViewController("/swagger-ui.html").setViewName("redirect:" + this.swaggerBaseUrl + "/swagger-ui/");
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        String workDir = FILE_PROTOCOL + HaloUtils.ensureSuffix((String)this.haloProperties.getWorkDir(), (String)HaloConst.FILE_SEPARATOR);
        registry.addResourceHandler(new String[]{"/**"}).addResourceLocations(new String[]{"classpath:/admin/"}).addResourceLocations(new String[]{workDir + "static/"});
        registry.addResourceHandler(new String[]{"/themes/**"}).addResourceLocations(new String[]{workDir + "templates/themes/"});
        String uploadUrlPattern = HaloUtils.ensureBoth((String)this.haloProperties.getUploadUrlPrefix(), (String)"/") + "**";
        String adminPathPattern = HaloUtils.ensureSuffix((String)this.haloProperties.getAdminPath(), (String)"/") + "**";
        registry.addResourceHandler(new String[]{uploadUrlPattern}).setCacheControl(CacheControl.maxAge((long)7L, (TimeUnit)TimeUnit.DAYS)).addResourceLocations(new String[]{workDir + "upload/"});
        registry.addResourceHandler(new String[]{adminPathPattern}).addResourceLocations(new String[]{"classpath:/admin/"});
        registry.addResourceHandler(new String[]{"swagger-ui.html"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/"});
        registry.addResourceHandler(new String[]{"/webjars/**"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/webjars/"});
    }

    public void addFormatters(FormatterRegistry registry) {
        registry.addConverterFactory((ConverterFactory)new StringToEnumConverterFactory());
    }
}

