/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.config;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import run.halo.app.config.properties.HaloProperties;
import run.halo.app.event.StaticStorageChangedEvent;
import run.halo.app.utils.HaloUtils;

public class HaloRequestMappingHandlerMapping
extends RequestMappingHandlerMapping
implements ApplicationListener<StaticStorageChangedEvent> {
    private static final Logger log = LoggerFactory.getLogger(HaloRequestMappingHandlerMapping.class);
    private final Set<String> blackPatterns = new HashSet(16);
    private final PathMatcher pathMatcher;
    private final HaloProperties haloProperties;

    public HaloRequestMappingHandlerMapping(HaloProperties haloProperties) {
        this.haloProperties = haloProperties;
        this.initBlackPatterns();
        this.pathMatcher = new AntPathMatcher();
    }

    protected HandlerMethod lookupHandlerMethod(String lookupPath, HttpServletRequest request) throws Exception {
        log.debug("Looking path: [{}]", (Object)lookupPath);
        for (String blackPattern : this.blackPatterns) {
            if (!this.pathMatcher.match(blackPattern, lookupPath)) continue;
            log.debug("Skipped path [{}] with pattern: [{}]", (Object)lookupPath, (Object)blackPattern);
            return null;
        }
        return super.lookupHandlerMethod(lookupPath, request);
    }

    private void initBlackPatterns() {
        String uploadUrlPattern = HaloUtils.ensureBoth((String)this.haloProperties.getUploadUrlPrefix(), (String)"/") + "**";
        String adminPathPattern = HaloUtils.ensureBoth((String)this.haloProperties.getAdminPath(), (String)"/") + "?*/**";
        this.blackPatterns.add("/themes/**");
        this.blackPatterns.add("/js/**");
        this.blackPatterns.add("/images/**");
        this.blackPatterns.add("/fonts/**");
        this.blackPatterns.add("/css/**");
        this.blackPatterns.add("/assets/**");
        this.blackPatterns.add("/color.less");
        this.blackPatterns.add("/swagger-ui.html");
        this.blackPatterns.add("/swagger-ui/**");
        this.blackPatterns.add("/csrf");
        this.blackPatterns.add("/webjars/**");
        this.blackPatterns.add(uploadUrlPattern);
        this.blackPatterns.add(adminPathPattern);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onApplicationEvent(StaticStorageChangedEvent event) {
        Path staticPath = event.getStaticPath();
        try (Stream<Path> rootPathStream = Files.list(staticPath);){
            HaloRequestMappingHandlerMapping haloRequestMappingHandlerMapping = this;
            synchronized (haloRequestMappingHandlerMapping) {
                this.blackPatterns.clear();
                this.initBlackPatterns();
                rootPathStream.forEach(rootPath -> {
                    if (Files.isDirectory(rootPath, new LinkOption[0])) {
                        String directoryPattern = "/" + rootPath.getFileName().toString() + "/**";
                        this.blackPatterns.add(directoryPattern);
                        log.debug("Exclude for folder path pattern: [{}]", (Object)directoryPattern);
                    } else {
                        String pathPattern = "/" + rootPath.getFileName().toString();
                        this.blackPatterns.add(pathPattern);
                        log.debug("Exclude for file path pattern: [{}]", (Object)pathPattern);
                    }
                });
            }
        }
        catch (IOException e) {
            log.error("Failed to refresh static directory mapping", (Throwable)e);
        }
    }
}

