/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.config;

import com.fasterxml.classmate.TypeResolver;
import io.swagger.models.auth.In;
import java.lang.reflect.Type;
import java.time.temporal.Temporal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.lang.NonNull;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;
import org.springframework.util.PathMatcher;
import run.halo.app.model.support.HaloConst;
import run.halo.app.utils.SwaggerUtils;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.schema.AlternateTypeRuleConvention;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.ApiKey;
import springfox.documentation.service.AuthorizationScope;
import springfox.documentation.service.Contact;
import springfox.documentation.service.SecurityReference;
import springfox.documentation.service.SecurityScheme;
import springfox.documentation.spi.service.contexts.OperationContext;
import springfox.documentation.spi.service.contexts.SecurityContext;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger.web.DocExpansion;
import springfox.documentation.swagger.web.ModelRendering;
import springfox.documentation.swagger.web.OperationsSorter;
import springfox.documentation.swagger.web.SecurityConfiguration;
import springfox.documentation.swagger.web.SecurityConfigurationBuilder;
import springfox.documentation.swagger.web.TagsSorter;
import springfox.documentation.swagger.web.UiConfiguration;
import springfox.documentation.swagger.web.UiConfigurationBuilder;

@Configuration
@ConditionalOnProperty(value={"springfox.documentation.enabled"}, havingValue="true", matchIfMissing=true)
public class SwaggerConfiguration {
    private static final Logger log = LoggerFactory.getLogger(SwaggerConfiguration.class);

    @Bean
    public Docket haloDefaultApi() {
        return this.buildApiDocket("run.halo.app.content.api", "run.halo.app.controller.content.api", "/api/content/**").securitySchemes(this.contentApiKeys()).securityContexts(this.contentSecurityContext());
    }

    @Bean
    public Docket haloAdminApi() {
        return this.buildApiDocket("run.halo.app.admin.api", "run.halo.app.controller.admin", "/api/admin/**").securitySchemes(this.adminApiKeys()).securityContexts(this.adminSecurityContext());
    }

    @Bean
    SecurityConfiguration security() {
        return SecurityConfigurationBuilder.builder().clientId("halo-app-client-id").clientSecret("halo-app-client-secret").realm("halo-app-realm").appName("halo-app").scopeSeparator(",").additionalQueryStringParams(null).useBasicAuthenticationWithAccessCodeGrant(Boolean.valueOf(false)).build();
    }

    @Bean
    UiConfiguration uiConfig() {
        return UiConfigurationBuilder.builder().deepLinking(Boolean.valueOf(true)).displayOperationId(Boolean.valueOf(false)).defaultModelsExpandDepth(Integer.valueOf(1)).defaultModelExpandDepth(Integer.valueOf(1)).defaultModelRendering(ModelRendering.EXAMPLE).displayRequestDuration(Boolean.valueOf(false)).docExpansion(DocExpansion.NONE).filter((Object)false).maxDisplayedTags(null).operationsSorter(OperationsSorter.ALPHA).showExtensions(Boolean.valueOf(false)).showCommonExtensions(Boolean.valueOf(false)).tagsSorter(TagsSorter.ALPHA).supportedSubmitMethods(UiConfiguration.Constants.DEFAULT_SUBMIT_METHODS).validatorUrl(null).build();
    }

    private Docket buildApiDocket(@NonNull String groupName, @NonNull String basePackage, @NonNull String antPattern) {
        Assert.hasText((String)groupName, (String)"Group name must not be blank");
        Assert.hasText((String)basePackage, (String)"Base package must not be blank");
        Assert.hasText((String)antPattern, (String)"Ant pattern must not be blank");
        return SwaggerUtils.defaultDocket().groupName(groupName).select().apis(RequestHandlerSelectors.basePackage((String)basePackage)).paths(PathSelectors.ant((String)antPattern)).build().apiInfo(this.apiInfo()).directModelSubstitute(Temporal.class, String.class);
    }

    private List<SecurityScheme> adminApiKeys() {
        return Arrays.asList(new ApiKey("ADMIN-Authorization", "ADMIN-Authorization", In.HEADER.name()), new ApiKey("admin_token", "admin_token", In.QUERY.name()));
    }

    private List<SecurityContext> adminSecurityContext() {
        AntPathMatcher pathMatcher = new AntPathMatcher();
        return Collections.singletonList(SecurityContext.builder().securityReferences(this.adminApiAuths()).operationSelector(arg_0 -> SwaggerConfiguration.lambda$adminSecurityContext$0((PathMatcher)pathMatcher, arg_0)).build());
    }

    private List<SecurityScheme> contentApiKeys() {
        return Arrays.asList(new ApiKey("API-Authorization", "API-Authorization", In.HEADER.name()), new ApiKey("api_access_key", "api_access_key", In.QUERY.name()));
    }

    private List<SecurityContext> contentSecurityContext() {
        AntPathMatcher pathMatcher = new AntPathMatcher();
        return Collections.singletonList(SecurityContext.builder().securityReferences(this.contentApiAuths()).operationSelector(arg_0 -> SwaggerConfiguration.lambda$contentSecurityContext$1((PathMatcher)pathMatcher, arg_0)).build());
    }

    private List<SecurityReference> adminApiAuths() {
        AuthorizationScope[] authorizationScopes = new AuthorizationScope[]{new AuthorizationScope("Admin api", "Access admin api")};
        return Arrays.asList(new SecurityReference("ADMIN-Authorization", authorizationScopes), new SecurityReference("admin_token", authorizationScopes));
    }

    private List<SecurityReference> contentApiAuths() {
        AuthorizationScope[] authorizationScopes = new AuthorizationScope[]{new AuthorizationScope("content api", "Access content api")};
        return Arrays.asList(new SecurityReference("API-Authorization", authorizationScopes), new SecurityReference("api_access_key", authorizationScopes));
    }

    private ApiInfo apiInfo() {
        return new ApiInfoBuilder().title("Halo API Documentation").description("Documentation for Halo API").version(HaloConst.HALO_VERSION).termsOfServiceUrl("https://github.com/halo-dev").contact(new Contact("halo-dev", "https://github.com/halo-dev/halo/issues", "hi@halo.run")).license("GNU General Public License v3.0").licenseUrl("https://github.com/halo-dev/halo/blob/master/LICENSE").build();
    }

    @Bean
    public AlternateTypeRuleConvention customizeConvention(TypeResolver resolver) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private Type sortMixin() {
        return SwaggerUtils.customMixin(Sort.class, Collections.singletonList(SwaggerUtils.propertyBuilder(String[].class, (String)"sort")));
    }

    private Type pageableMixin() {
        return SwaggerUtils.customMixin(Pageable.class, Arrays.asList(SwaggerUtils.propertyBuilder(Integer.class, (String)"page"), SwaggerUtils.propertyBuilder(Integer.class, (String)"size"), SwaggerUtils.propertyBuilder(String[].class, (String)"sort")));
    }

    private static /* synthetic */ boolean lambda$contentSecurityContext$1(PathMatcher pathMatcher, OperationContext operationContext) {
        String requestMappingPattern = operationContext.requestMappingPattern();
        return pathMatcher.match("/api/content/**/*", requestMappingPattern);
    }

    private static /* synthetic */ boolean lambda$adminSecurityContext$0(PathMatcher pathMatcher, OperationContext operationContext) {
        String requestMappingPattern = operationContext.requestMappingPattern();
        return pathMatcher.match("/api/admin/**/*", requestMappingPattern);
    }
}

