/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.config.attributeconverter;

import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.orm.jpa.persistenceunit.MutablePersistenceUnitInfo;
import org.springframework.orm.jpa.persistenceunit.PersistenceUnitPostProcessor;
import org.springframework.util.ClassUtils;
import run.halo.app.config.attributeconverter.AttributeConverterAutoGenerator;
import run.halo.app.model.enums.ValueEnum;
import run.halo.app.model.properties.PropertyEnum;

class AutoGenerateConverterPersistenceUnitPostProcessor
implements PersistenceUnitPostProcessor {
    private static final String PACKAGE_TO_SCAN = "run.halo.app";
    private final ConfigurableListableBeanFactory factory;

    public AutoGenerateConverterPersistenceUnitPostProcessor(ConfigurableListableBeanFactory factory) {
        this.factory = factory;
    }

    public void postProcessPersistenceUnitInfo(MutablePersistenceUnitInfo pui) {
        AttributeConverterAutoGenerator generator = new AttributeConverterAutoGenerator(this.factory.getBeanClassLoader());
        this.findValueEnumClasses().stream().map(arg_0 -> ((AttributeConverterAutoGenerator)generator).generate(arg_0)).map(Class::getName).forEach(arg_0 -> ((MutablePersistenceUnitInfo)pui).addManagedClassName(arg_0));
    }

    private Set<Class<?>> findValueEnumClasses() {
        ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false);
        scanner.addIncludeFilter((TypeFilter)new AssignableTypeFilter(ValueEnum.class));
        scanner.addExcludeFilter((TypeFilter)new AssignableTypeFilter(PropertyEnum.class));
        return scanner.findCandidateComponents(PACKAGE_TO_SCAN).stream().filter(bd -> bd.getBeanClassName() != null).map(bd -> ClassUtils.resolveClassName((String)bd.getBeanClassName(), null)).collect(Collectors.toUnmodifiableSet());
    }
}

