/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.config.properties;

import java.time.Duration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import run.halo.app.model.enums.Mode;
import run.halo.app.model.support.HaloConst;
import run.halo.app.utils.HaloUtils;

@ConfigurationProperties(value="halo")
public class HaloProperties {
    private boolean authEnabled = true;
    private Mode mode = Mode.PRODUCTION;
    private String adminPath = "admin";
    private String workDir = HaloUtils.ensureSuffix((String)HaloConst.USER_HOME, (String)HaloConst.FILE_SEPARATOR) + ".halo" + HaloConst.FILE_SEPARATOR;
    private String backupDir = HaloUtils.ensureSuffix((String)HaloConst.TEMP_DIR, (String)HaloConst.FILE_SEPARATOR) + "halo-backup" + HaloConst.FILE_SEPARATOR;
    private String backupMarkdownDir = HaloUtils.ensureSuffix((String)HaloConst.TEMP_DIR, (String)HaloConst.FILE_SEPARATOR) + "halo-backup-markdown" + HaloConst.FILE_SEPARATOR;
    private String dataExportDir = HaloUtils.ensureSuffix((String)HaloConst.TEMP_DIR, (String)HaloConst.FILE_SEPARATOR) + "halo-data-export" + HaloConst.FILE_SEPARATOR;
    private String uploadUrlPrefix = "upload";
    private Duration downloadTimeout = Duration.ofSeconds(30L);
    private String cache = "memory";

    public boolean isAuthEnabled() {
        return this.authEnabled;
    }

    public Mode getMode() {
        return this.mode;
    }

    public String getAdminPath() {
        return this.adminPath;
    }

    public String getWorkDir() {
        return this.workDir;
    }

    public String getBackupDir() {
        return this.backupDir;
    }

    public String getBackupMarkdownDir() {
        return this.backupMarkdownDir;
    }

    public String getDataExportDir() {
        return this.dataExportDir;
    }

    public String getUploadUrlPrefix() {
        return this.uploadUrlPrefix;
    }

    public Duration getDownloadTimeout() {
        return this.downloadTimeout;
    }

    public String getCache() {
        return this.cache;
    }

    public void setAuthEnabled(boolean authEnabled) {
        this.authEnabled = authEnabled;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public void setAdminPath(String adminPath) {
        this.adminPath = adminPath;
    }

    public void setWorkDir(String workDir) {
        this.workDir = workDir;
    }

    public void setBackupDir(String backupDir) {
        this.backupDir = backupDir;
    }

    public void setBackupMarkdownDir(String backupMarkdownDir) {
        this.backupMarkdownDir = backupMarkdownDir;
    }

    public void setDataExportDir(String dataExportDir) {
        this.dataExportDir = dataExportDir;
    }

    public void setUploadUrlPrefix(String uploadUrlPrefix) {
        this.uploadUrlPrefix = uploadUrlPrefix;
    }

    public void setDownloadTimeout(Duration downloadTimeout) {
        this.downloadTimeout = downloadTimeout;
    }

    public void setCache(String cache) {
        this.cache = cache;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HaloProperties)) {
            return false;
        }
        HaloProperties other = (HaloProperties)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isAuthEnabled() != other.isAuthEnabled()) {
            return false;
        }
        Mode this$mode = this.getMode();
        Mode other$mode = other.getMode();
        if (this$mode == null ? other$mode != null : !this$mode.equals(other$mode)) {
            return false;
        }
        String this$adminPath = this.getAdminPath();
        String other$adminPath = other.getAdminPath();
        if (this$adminPath == null ? other$adminPath != null : !this$adminPath.equals(other$adminPath)) {
            return false;
        }
        String this$workDir = this.getWorkDir();
        String other$workDir = other.getWorkDir();
        if (this$workDir == null ? other$workDir != null : !this$workDir.equals(other$workDir)) {
            return false;
        }
        String this$backupDir = this.getBackupDir();
        String other$backupDir = other.getBackupDir();
        if (this$backupDir == null ? other$backupDir != null : !this$backupDir.equals(other$backupDir)) {
            return false;
        }
        String this$backupMarkdownDir = this.getBackupMarkdownDir();
        String other$backupMarkdownDir = other.getBackupMarkdownDir();
        if (this$backupMarkdownDir == null ? other$backupMarkdownDir != null : !this$backupMarkdownDir.equals(other$backupMarkdownDir)) {
            return false;
        }
        String this$dataExportDir = this.getDataExportDir();
        String other$dataExportDir = other.getDataExportDir();
        if (this$dataExportDir == null ? other$dataExportDir != null : !this$dataExportDir.equals(other$dataExportDir)) {
            return false;
        }
        String this$uploadUrlPrefix = this.getUploadUrlPrefix();
        String other$uploadUrlPrefix = other.getUploadUrlPrefix();
        if (this$uploadUrlPrefix == null ? other$uploadUrlPrefix != null : !this$uploadUrlPrefix.equals(other$uploadUrlPrefix)) {
            return false;
        }
        Duration this$downloadTimeout = this.getDownloadTimeout();
        Duration other$downloadTimeout = other.getDownloadTimeout();
        if (this$downloadTimeout == null ? other$downloadTimeout != null : !((Object)this$downloadTimeout).equals(other$downloadTimeout)) {
            return false;
        }
        String this$cache = this.getCache();
        String other$cache = other.getCache();
        return !(this$cache == null ? other$cache != null : !this$cache.equals(other$cache));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HaloProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAuthEnabled() ? 79 : 97);
        Mode $mode = this.getMode();
        result = result * 59 + ($mode == null ? 43 : $mode.hashCode());
        String $adminPath = this.getAdminPath();
        result = result * 59 + ($adminPath == null ? 43 : $adminPath.hashCode());
        String $workDir = this.getWorkDir();
        result = result * 59 + ($workDir == null ? 43 : $workDir.hashCode());
        String $backupDir = this.getBackupDir();
        result = result * 59 + ($backupDir == null ? 43 : $backupDir.hashCode());
        String $backupMarkdownDir = this.getBackupMarkdownDir();
        result = result * 59 + ($backupMarkdownDir == null ? 43 : $backupMarkdownDir.hashCode());
        String $dataExportDir = this.getDataExportDir();
        result = result * 59 + ($dataExportDir == null ? 43 : $dataExportDir.hashCode());
        String $uploadUrlPrefix = this.getUploadUrlPrefix();
        result = result * 59 + ($uploadUrlPrefix == null ? 43 : $uploadUrlPrefix.hashCode());
        Duration $downloadTimeout = this.getDownloadTimeout();
        result = result * 59 + ($downloadTimeout == null ? 43 : ((Object)$downloadTimeout).hashCode());
        String $cache = this.getCache();
        result = result * 59 + ($cache == null ? 43 : $cache.hashCode());
        return result;
    }

    public String toString() {
        return "HaloProperties(authEnabled=" + this.isAuthEnabled() + ", mode=" + this.getMode() + ", adminPath=" + this.getAdminPath() + ", workDir=" + this.getWorkDir() + ", backupDir=" + this.getBackupDir() + ", backupMarkdownDir=" + this.getBackupMarkdownDir() + ", dataExportDir=" + this.getDataExportDir() + ", uploadUrlPrefix=" + this.getUploadUrlPrefix() + ", downloadTimeout=" + this.getDownloadTimeout() + ", cache=" + this.getCache() + ")";
    }
}

