/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.controller.admin.api;

import io.swagger.annotations.ApiOperation;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import run.halo.app.annotation.DisableOnCondition;
import run.halo.app.cache.lock.CacheLock;
import run.halo.app.model.dto.EnvironmentDTO;
import run.halo.app.model.dto.LoginPreCheckDTO;
import run.halo.app.model.entity.User;
import run.halo.app.model.enums.MFAType;
import run.halo.app.model.params.LoginParam;
import run.halo.app.model.params.ResetPasswordParam;
import run.halo.app.model.params.ResetPasswordSendCodeParam;
import run.halo.app.model.properties.PrimaryProperties;
import run.halo.app.model.properties.PropertyEnum;
import run.halo.app.model.support.BaseResponse;
import run.halo.app.security.token.AuthToken;
import run.halo.app.service.AdminService;
import run.halo.app.service.OptionService;

@RestController
@RequestMapping(value={"/api/admin"})
public class AdminController {
    private static final Logger log = LoggerFactory.getLogger(AdminController.class);
    private final AdminService adminService;
    private final OptionService optionService;

    public AdminController(AdminService adminService, OptionService optionService) {
        this.adminService = adminService;
        this.optionService = optionService;
    }

    @GetMapping(value={"/is_installed"})
    @ApiOperation(value="Checks Installation status")
    public boolean isInstall() {
        return (Boolean)this.optionService.getByPropertyOrDefault((PropertyEnum)PrimaryProperties.IS_INSTALLED, Boolean.class, (Object)false);
    }

    @PostMapping(value={"login/precheck"})
    @ApiOperation(value="Login")
    @CacheLock(autoDelete=false, prefix="login_precheck")
    public LoginPreCheckDTO authPreCheck(@RequestBody @Valid LoginParam loginParam) {
        User user = this.adminService.authenticate(loginParam);
        return new LoginPreCheckDTO(MFAType.useMFA((MFAType)user.getMfaType()));
    }

    @PostMapping(value={"login"})
    @ApiOperation(value="Login")
    @CacheLock(autoDelete=false, prefix="login_auth")
    public AuthToken auth(@RequestBody @Valid LoginParam loginParam) {
        return this.adminService.authCodeCheck(loginParam);
    }

    @PostMapping(value={"logout"})
    @ApiOperation(value="Logs out (Clear session)")
    @CacheLock(autoDelete=false)
    public void logout() {
        this.adminService.clearToken();
    }

    @PostMapping(value={"password/code"})
    @ApiOperation(value="Sends reset password verify code")
    @CacheLock(autoDelete=false)
    @DisableOnCondition
    public void sendResetCode(@RequestBody @Valid ResetPasswordSendCodeParam param) {
        this.adminService.sendResetPasswordCode(param);
    }

    @PutMapping(value={"password/reset"})
    @ApiOperation(value="Resets password by verify code")
    @CacheLock(autoDelete=false)
    @DisableOnCondition
    public void resetPassword(@RequestBody @Valid ResetPasswordParam param) {
        this.adminService.resetPasswordByCode(param);
    }

    @PostMapping(value={"refresh/{refreshToken}"})
    @ApiOperation(value="Refreshes token")
    @CacheLock(autoDelete=false)
    public AuthToken refresh(@PathVariable(value="refreshToken") String refreshToken) {
        return this.adminService.refreshToken(refreshToken);
    }

    @GetMapping(value={"environments"})
    @ApiOperation(value="Gets environments info")
    public EnvironmentDTO getEnvironments() {
        return this.adminService.getEnvironments();
    }

    @GetMapping(value={"halo/logfile"})
    @ApiOperation(value="Gets halo log file content")
    @DisableOnCondition
    public BaseResponse<String> getLogFiles(@RequestParam(value="lines") Long lines) {
        return BaseResponse.ok((String)HttpStatus.OK.getReasonPhrase(), (Object)this.adminService.getLogFiles(lines));
    }
}

