/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.controller.admin.api;

import io.swagger.annotations.ApiOperation;
import java.util.LinkedList;
import java.util.List;
import javax.validation.Valid;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import run.halo.app.model.dto.AttachmentDTO;
import run.halo.app.model.entity.Attachment;
import run.halo.app.model.enums.AttachmentType;
import run.halo.app.model.params.AttachmentParam;
import run.halo.app.model.params.AttachmentQuery;
import run.halo.app.service.AttachmentService;

@RestController
@RequestMapping(value={"/api/admin/attachments"})
public class AttachmentController {
    private final AttachmentService attachmentService;

    public AttachmentController(AttachmentService attachmentService) {
        this.attachmentService = attachmentService;
    }

    @GetMapping
    public Page<AttachmentDTO> pageBy(@PageableDefault(sort={"createTime"}, direction=Sort.Direction.DESC) Pageable pageable, AttachmentQuery attachmentQuery) {
        return this.attachmentService.pageDtosBy(pageable, attachmentQuery);
    }

    @GetMapping(value={"{id:\\d+}"})
    @ApiOperation(value="Gets attachment detail by id")
    public AttachmentDTO getBy(@PathVariable(value="id") Integer id) {
        Attachment attachment = (Attachment)this.attachmentService.getById((Object)id);
        return this.attachmentService.convertToDto(attachment);
    }

    @PutMapping(value={"{attachmentId:\\d+}"})
    @ApiOperation(value="Updates a attachment")
    public AttachmentDTO updateBy(@PathVariable(value="attachmentId") Integer attachmentId, @RequestBody @Valid AttachmentParam attachmentParam) {
        Attachment attachment = (Attachment)this.attachmentService.getById((Object)attachmentId);
        attachmentParam.update((Object)attachment);
        return (AttachmentDTO)new AttachmentDTO().convertFrom((Object)((Attachment)this.attachmentService.update((Object)attachment)));
    }

    @DeleteMapping(value={"{id:\\d+}"})
    @ApiOperation(value="Deletes attachment permanently by id")
    public AttachmentDTO deletePermanently(@PathVariable(value="id") Integer id) {
        return this.attachmentService.convertToDto(this.attachmentService.removePermanently(id));
    }

    @DeleteMapping
    @ApiOperation(value="Deletes attachments permanently in batch by id array")
    public List<Attachment> deletePermanentlyInBatch(@RequestBody List<Integer> ids) {
        return this.attachmentService.removePermanently(ids);
    }

    @PostMapping(value={"upload"})
    @ApiOperation(value="Uploads single file")
    public AttachmentDTO uploadAttachment(@RequestPart(value="file") MultipartFile file) {
        return this.attachmentService.convertToDto(this.attachmentService.upload(file));
    }

    @PostMapping(value={"uploads"}, consumes={"multipart/form-data"})
    @ApiOperation(value="Uploads multi files (Invalid in Swagger UI)")
    public List<AttachmentDTO> uploadAttachments(@RequestPart(value="files") MultipartFile[] files) {
        LinkedList<AttachmentDTO> result = new LinkedList<AttachmentDTO>();
        for (MultipartFile file : files) {
            Attachment attachment = this.attachmentService.upload(file);
            result.add(this.attachmentService.convertToDto(attachment));
        }
        return result;
    }

    @GetMapping(value={"media_types"})
    @ApiOperation(value="Lists all of media types")
    public List<String> listMediaTypes() {
        return this.attachmentService.listAllMediaType();
    }

    @GetMapping(value={"types"})
    @ApiOperation(value="Lists all of types.")
    public List<AttachmentType> listTypes() {
        return this.attachmentService.listAllType();
    }
}

