/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.controller.admin.api;

import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import run.halo.app.annotation.DisableOnCondition;
import run.halo.app.config.properties.HaloProperties;
import run.halo.app.exception.NotFoundException;
import run.halo.app.model.dto.BackupDTO;
import run.halo.app.model.dto.post.BasePostDetailDTO;
import run.halo.app.model.params.PostMarkdownParam;
import run.halo.app.service.BackupService;

@RestController
@RequestMapping(value={"/api/admin/backups"})
public class BackupController {
    private static final Logger log = LoggerFactory.getLogger(BackupController.class);
    private final BackupService backupService;
    private final HaloProperties haloProperties;

    public BackupController(BackupService backupService, HaloProperties haloProperties) {
        this.backupService = backupService;
        this.haloProperties = haloProperties;
    }

    @GetMapping(value={"work-dir/fetch"})
    public BackupDTO getWorkDirBackup(@RequestParam(value="filename") String filename) {
        return (BackupDTO)this.backupService.getBackup(Paths.get(this.haloProperties.getBackupDir(), filename), BackupService.BackupType.WHOLE_SITE).orElseThrow(() -> new NotFoundException("\u5907\u4efd\u6587\u4ef6 " + filename + " \u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664\uff01").setErrorData((Object)filename));
    }

    @GetMapping(value={"data/fetch"})
    public BackupDTO getDataBackup(@RequestParam(value="filename") String filename) {
        return (BackupDTO)this.backupService.getBackup(Paths.get(this.haloProperties.getDataExportDir(), filename), BackupService.BackupType.JSON_DATA).orElseThrow(() -> new NotFoundException("\u5907\u4efd\u6587\u4ef6 " + filename + " \u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664\uff01").setErrorData((Object)filename));
    }

    @GetMapping(value={"markdown/fetch"})
    public BackupDTO getMarkdownBackup(@RequestParam(value="filename") String filename) {
        return (BackupDTO)this.backupService.getBackup(Paths.get(this.haloProperties.getBackupMarkdownDir(), filename), BackupService.BackupType.MARKDOWN).orElseThrow(() -> new NotFoundException("\u5907\u4efd\u6587\u4ef6 " + filename + " \u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664\uff01").setErrorData((Object)filename));
    }

    @PostMapping(value={"work-dir"})
    @ApiOperation(value="Backups work directory")
    @DisableOnCondition
    public BackupDTO backupHalo(@RequestBody List<String> options) {
        return this.backupService.backupWorkDirectory(options);
    }

    @GetMapping(value={"work-dir/options"})
    @ApiOperation(value="Gets items that can be backed up")
    public List<String> listBackupItems() throws IOException {
        return Files.list(Paths.get(this.haloProperties.getWorkDir(), new String[0])).map(Path::getFileName).filter(Objects::nonNull).map(Path::toString).sorted().collect(Collectors.toList());
    }

    @GetMapping(value={"work-dir"})
    @ApiOperation(value="Gets all work directory backups")
    public List<BackupDTO> listBackups() {
        return this.backupService.listWorkDirBackups();
    }

    @GetMapping(value={"work-dir/{filename:.+}"})
    @ApiOperation(value="Downloads a work directory backup file")
    @DisableOnCondition
    public ResponseEntity<Resource> downloadBackup(@PathVariable(value="filename") String filename, HttpServletRequest request) {
        log.info("Trying to download backup file: [{}]", (Object)filename);
        Resource backupResource = this.backupService.loadFileAsResource(this.haloProperties.getBackupDir(), filename);
        String contentType = "application/octet-stream";
        try {
            contentType = request.getServletContext().getMimeType(backupResource.getFile().getAbsolutePath());
        }
        catch (IOException e) {
            log.warn("Could not determine file type", (Throwable)e);
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(MediaType.parseMediaType((String)contentType)).header("Content-Disposition", new String[]{"attachment; filename=\"" + backupResource.getFilename() + "\""})).body((Object)backupResource);
    }

    @DeleteMapping(value={"work-dir"})
    @ApiOperation(value="Deletes a work directory backup")
    @DisableOnCondition
    public void deleteBackup(@RequestParam(value="filename") String filename) {
        this.backupService.deleteWorkDirBackup(filename);
    }

    @PostMapping(value={"markdown/import"})
    @ApiOperation(value="Imports markdown")
    public BasePostDetailDTO backupMarkdowns(@RequestPart(value="file") MultipartFile file) throws IOException {
        return this.backupService.importMarkdown(file);
    }

    @PostMapping(value={"data"})
    @ApiOperation(value="Exports all data")
    @DisableOnCondition
    public BackupDTO exportData() {
        return this.backupService.exportData();
    }

    @GetMapping(value={"data"})
    @ApiOperation(value="Lists all exported data")
    public List<BackupDTO> listExportedData() {
        return this.backupService.listExportedData();
    }

    @DeleteMapping(value={"data"})
    @ApiOperation(value="Deletes a exported data")
    @DisableOnCondition
    public void deleteExportedData(@RequestParam(value="filename") String filename) {
        this.backupService.deleteExportedData(filename);
    }

    @GetMapping(value={"data/{fileName:.+}"})
    @ApiOperation(value="Downloads a exported data")
    @DisableOnCondition
    public ResponseEntity<Resource> downloadExportedData(@PathVariable(value="fileName") String fileName, HttpServletRequest request) {
        log.info("Try to download exported data file: [{}]", (Object)fileName);
        Resource exportDataResource = this.backupService.loadFileAsResource(this.haloProperties.getDataExportDir(), fileName);
        String contentType = "application/octet-stream";
        try {
            contentType = request.getServletContext().getMimeType(exportDataResource.getFile().getAbsolutePath());
        }
        catch (IOException e) {
            log.warn("Could not determine file type", (Throwable)e);
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(MediaType.parseMediaType((String)contentType)).header("Content-Disposition", new String[]{"attachment; filename=\"" + exportDataResource.getFilename() + "\""})).body((Object)exportDataResource);
    }

    @PostMapping(value={"markdown/export"})
    @ApiOperation(value="Exports markdowns")
    @DisableOnCondition
    public BackupDTO exportMarkdowns(@RequestBody PostMarkdownParam postMarkdownParam) throws IOException {
        return this.backupService.exportMarkdowns(postMarkdownParam);
    }

    @GetMapping(value={"markdown/export"})
    @ApiOperation(value="Gets all markdown backups")
    public List<BackupDTO> listMarkdowns() {
        return this.backupService.listMarkdowns();
    }

    @DeleteMapping(value={"markdown/export"})
    @ApiOperation(value="Deletes a markdown backup")
    @DisableOnCondition
    public void deleteMarkdown(@RequestParam(value="filename") String filename) {
        this.backupService.deleteMarkdown(filename);
    }

    @GetMapping(value={"markdown/export/{fileName:.+}"})
    @ApiOperation(value="Downloads a work markdown backup file")
    @DisableOnCondition
    public ResponseEntity<Resource> downloadMarkdown(@PathVariable(value="fileName") String fileName, HttpServletRequest request) {
        log.info("Try to download markdown backup file: [{}]", (Object)fileName);
        Resource backupResource = this.backupService.loadFileAsResource(this.haloProperties.getBackupMarkdownDir(), fileName);
        String contentType = "application/octet-stream";
        try {
            contentType = request.getServletContext().getMimeType(backupResource.getFile().getAbsolutePath());
        }
        catch (IOException e) {
            log.warn("Could not determine file type", (Throwable)e);
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(MediaType.parseMediaType((String)contentType)).header("Content-Disposition", new String[]{"attachment; filename=\"" + backupResource.getFilename() + "\""})).body((Object)backupResource);
    }
}

