/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.controller.admin.api;

import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.SortDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import run.halo.app.model.dto.CategoryDTO;
import run.halo.app.model.entity.Category;
import run.halo.app.model.params.CategoryParam;
import run.halo.app.model.vo.CategoryVO;
import run.halo.app.service.CategoryService;
import run.halo.app.service.PostCategoryService;

@RestController
@RequestMapping(value={"/api/admin/categories"})
public class CategoryController {
    private final CategoryService categoryService;
    private final PostCategoryService postCategoryService;

    public CategoryController(CategoryService categoryService, PostCategoryService postCategoryService) {
        this.categoryService = categoryService;
        this.postCategoryService = postCategoryService;
    }

    @GetMapping(value={"{categoryId:\\d+}"})
    @ApiOperation(value="Gets category detail")
    public CategoryDTO getBy(@PathVariable(value="categoryId") Integer categoryId) {
        return this.categoryService.convertTo((Category)this.categoryService.getById((Object)categoryId));
    }

    @GetMapping
    @ApiOperation(value="Lists all categories")
    public List<? extends CategoryDTO> listAll(@SortDefault(sort={"priority"}, direction=Sort.Direction.ASC) Sort sort, @RequestParam(name="more", required=false, defaultValue="false") boolean more) {
        if (more) {
            return this.postCategoryService.listCategoryWithPostCountDto(sort);
        }
        return this.categoryService.convertTo(this.categoryService.listAll(sort));
    }

    @GetMapping(value={"tree_view"})
    @ApiOperation(value="List all categories as tree")
    public List<CategoryVO> listAsTree(@SortDefault(sort={"priority"}, direction=Sort.Direction.ASC) Sort sort) {
        return this.categoryService.listAsTree(sort);
    }

    @PostMapping
    @ApiOperation(value="Creates category")
    public CategoryDTO createBy(@RequestBody @Valid CategoryParam categoryParam) {
        Category category = categoryParam.convertTo();
        return this.categoryService.convertTo((Category)this.categoryService.create((Object)category));
    }

    @PutMapping(value={"{categoryId:\\d+}"})
    @ApiOperation(value="Updates category")
    public CategoryDTO updateBy(@PathVariable(value="categoryId") Integer categoryId, @RequestBody @Valid CategoryParam categoryParam) {
        Category categoryToUpdate = (Category)this.categoryService.getById((Object)categoryId);
        categoryParam.update(categoryToUpdate);
        return this.categoryService.convertTo((Category)this.categoryService.update((Object)categoryToUpdate));
    }

    @PutMapping(value={"/batch"})
    @ApiOperation(value="Updates category in batch")
    public List<CategoryDTO> updateBatchBy(@RequestBody List<@Valid CategoryParam> categoryParams) {
        List categoriesToUpdate = categoryParams.stream().filter(categoryParam -> Objects.nonNull(categoryParam.getId())).map(categoryParam -> {
            Category categoryToUpdate = (Category)this.categoryService.getById((Object)categoryParam.getId());
            categoryParam.update(categoryToUpdate);
            return categoryToUpdate;
        }).collect(Collectors.toList());
        return this.categoryService.convertTo(this.categoryService.updateInBatch(categoriesToUpdate));
    }

    @DeleteMapping(value={"{categoryId:\\d+}"})
    @ApiOperation(value="Deletes category")
    public void deletePermanently(@PathVariable(value="categoryId") Integer categoryId) {
        this.categoryService.removeCategoryAndPostCategoryBy(categoryId);
    }
}

