/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.controller.admin.api;

import io.swagger.annotations.ApiOperation;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import run.halo.app.cache.lock.CacheLock;
import run.halo.app.event.logger.LogEvent;
import run.halo.app.exception.BadRequestException;
import run.halo.app.model.entity.BaseComment;
import run.halo.app.model.entity.Category;
import run.halo.app.model.entity.Menu;
import run.halo.app.model.entity.PostComment;
import run.halo.app.model.entity.User;
import run.halo.app.model.enums.LogType;
import run.halo.app.model.enums.PostStatus;
import run.halo.app.model.params.CategoryParam;
import run.halo.app.model.params.InstallParam;
import run.halo.app.model.params.MenuParam;
import run.halo.app.model.params.PostParam;
import run.halo.app.model.params.SheetParam;
import run.halo.app.model.params.UserParam;
import run.halo.app.model.properties.BlogProperties;
import run.halo.app.model.properties.OtherProperties;
import run.halo.app.model.properties.PrimaryProperties;
import run.halo.app.model.properties.PropertyEnum;
import run.halo.app.model.support.BaseResponse;
import run.halo.app.model.support.CreateCheck;
import run.halo.app.model.vo.PostDetailVO;
import run.halo.app.service.CategoryService;
import run.halo.app.service.MenuService;
import run.halo.app.service.OptionService;
import run.halo.app.service.PostCommentService;
import run.halo.app.service.PostService;
import run.halo.app.service.SheetService;
import run.halo.app.service.UserService;
import run.halo.app.utils.DateUtils;
import run.halo.app.utils.ValidationUtils;

@Controller
@RequestMapping(value={"/api/admin/installations"})
public class InstallController {
    private static final Logger log = LoggerFactory.getLogger(InstallController.class);
    private final UserService userService;
    private final CategoryService categoryService;
    private final PostService postService;
    private final SheetService sheetService;
    private final PostCommentService postCommentService;
    private final OptionService optionService;
    private final MenuService menuService;
    private final ApplicationEventPublisher eventPublisher;

    public InstallController(UserService userService, CategoryService categoryService, PostService postService, SheetService sheetService, PostCommentService postCommentService, OptionService optionService, MenuService menuService, ApplicationEventPublisher eventPublisher) {
        this.userService = userService;
        this.categoryService = categoryService;
        this.postService = postService;
        this.sheetService = sheetService;
        this.postCommentService = postCommentService;
        this.optionService = optionService;
        this.menuService = menuService;
        this.eventPublisher = eventPublisher;
    }

    @PostMapping
    @ResponseBody
    @CacheLock
    @ApiOperation(value="Initializes the blog")
    public BaseResponse<String> installBlog(@RequestBody InstallParam installParam) {
        ValidationUtils.validate((Object)installParam, (Class[])new Class[]{CreateCheck.class});
        boolean isInstalled = (Boolean)this.optionService.getByPropertyOrDefault((PropertyEnum)PrimaryProperties.IS_INSTALLED, Boolean.class, (Object)false);
        if (isInstalled) {
            throw new BadRequestException("\u8be5\u535a\u5ba2\u5df2\u521d\u59cb\u5316\uff0c\u4e0d\u80fd\u518d\u6b21\u5b89\u88c5\uff01");
        }
        this.initSettings(installParam);
        User user = this.createUser(installParam);
        Category category = this.createDefaultCategoryIfAbsent();
        PostDetailVO post = this.createDefaultPostIfAbsent(category);
        this.createDefaultSheet();
        this.createDefaultComment(post);
        this.createDefaultMenu();
        this.eventPublisher.publishEvent((ApplicationEvent)new LogEvent((Object)this, user.getId().toString(), LogType.BLOG_INITIALIZED, "\u535a\u5ba2\u5df2\u6210\u529f\u521d\u59cb\u5316"));
        return BaseResponse.ok((String)"\u5b89\u88c5\u5b8c\u6210\uff01");
    }

    private void createDefaultMenu() {
        long menuCount = this.menuService.count();
        if (menuCount > 0L) {
            return;
        }
        MenuParam menuIndex = new MenuParam();
        menuIndex.setName("\u9996\u9875");
        menuIndex.setUrl("/");
        menuIndex.setPriority(Integer.valueOf(1));
        this.menuService.create((Object)((Menu)menuIndex.convertTo()));
        MenuParam menuArchive = new MenuParam();
        menuArchive.setName("\u6587\u7ae0\u5f52\u6863");
        menuArchive.setUrl("/archives");
        menuArchive.setPriority(Integer.valueOf(2));
        this.menuService.create((Object)((Menu)menuArchive.convertTo()));
        MenuParam menuCategory = new MenuParam();
        menuCategory.setName("\u9ed8\u8ba4\u5206\u7c7b");
        menuCategory.setUrl("/categories/default");
        menuCategory.setPriority(Integer.valueOf(3));
        this.menuService.create((Object)((Menu)menuCategory.convertTo()));
        MenuParam menuSheet = new MenuParam();
        menuSheet.setName("\u5173\u4e8e\u9875\u9762");
        menuSheet.setUrl("/s/about");
        menuSheet.setPriority(Integer.valueOf(4));
        this.menuService.create((Object)((Menu)menuSheet.convertTo()));
    }

    @Nullable
    private void createDefaultComment(@Nullable PostDetailVO post) {
        if (post == null) {
            return;
        }
        long commentCount = this.postCommentService.count();
        if (commentCount > 0L) {
            return;
        }
        PostComment comment = new PostComment();
        comment.setAuthor("Halo");
        comment.setAuthorUrl("https://halo.run");
        comment.setContent("\u6b22\u8fce\u4f7f\u7528 Halo\uff0c\u8fd9\u662f\u4f60\u7684\u7b2c\u4e00\u6761\u8bc4\u8bba\uff0c\u5934\u50cf\u6765\u81ea [Gravatar](https://cn.gravatar.com)\uff0c\u4f60\u4e5f\u53ef\u4ee5\u901a\u8fc7\u6ce8\u518c [Gravatar](https://cn.gravatar.com) \u6765\u663e\u793a\u81ea\u5df1\u7684\u5934\u50cf\u3002");
        comment.setEmail("hi@halo.run");
        comment.setPostId(post.getId());
        this.postCommentService.create((BaseComment)comment);
    }

    @Nullable
    private PostDetailVO createDefaultPostIfAbsent(@Nullable Category category) {
        long publishedCount = this.postService.countByStatus(PostStatus.PUBLISHED);
        if (publishedCount > 0L) {
            return null;
        }
        PostParam postParam = new PostParam();
        postParam.setSlug("hello-halo");
        postParam.setTitle("Hello Halo");
        postParam.setStatus(PostStatus.PUBLISHED);
        postParam.setOriginalContent("## Hello Halo\n\n\u5982\u679c\u4f60\u770b\u5230\u4e86\u8fd9\u4e00\u7bc7\u6587\u7ae0\uff0c\u90a3\u4e48\u8bc1\u660e\u4f60\u5df2\u7ecf\u5b89\u88c5\u6210\u529f\u4e86\uff0c\u611f\u8c22\u4f7f\u7528 [Halo](https://halo.run) \u8fdb\u884c\u521b\u4f5c\uff0c\u5e0c\u671b\u80fd\u591f\u4f7f\u7528\u6109\u5feb\u3002\n\n## \u76f8\u5173\u94fe\u63a5\n\n- \u5b98\u7f51\uff1a[https://halo.run](https://halo.run)\n- \u6587\u6863\uff1a[https://docs.halo.run](https://docs.halo.run)\n- \u793e\u533a\uff1a[https://bbs.halo.run](https://bbs.halo.run)\n- \u4e3b\u9898\u4ed3\u5e93\uff1a[https://halo.run/themes.html](https://halo.run/themes.html)\n- \u5f00\u6e90\u5730\u5740\uff1a[https://github.com/halo-dev/halo](https://github.com/halo-dev/halo)\n\n\u5728\u4f7f\u7528\u8fc7\u7a0b\u4e2d\uff0c\u6709\u4efb\u4f55\u95ee\u9898\u90fd\u53ef\u4ee5\u901a\u8fc7\u4ee5\u4e0a\u94fe\u63a5\u627e\u5bfb\u7b54\u6848\uff0c\u6216\u8005\u8054\u7cfb\u6211\u4eec\u3002\n\n> \u8fd9\u662f\u4e00\u7bc7\u81ea\u52a8\u751f\u6210\u7684\u6587\u7ae0\uff0c\u8bf7\u5220\u9664\u8fd9\u7bc7\u6587\u7ae0\u4e4b\u540e\u5f00\u59cb\u4f60\u7684\u521b\u4f5c\u5427\uff01\n\n");
        HashSet<Integer> categoryIds = new HashSet<Integer>();
        if (category != null) {
            categoryIds.add(category.getId());
            postParam.setCategoryIds(categoryIds);
        }
        return this.postService.createBy(postParam.convertTo(), Collections.emptySet(), categoryIds, false);
    }

    @Nullable
    private void createDefaultSheet() {
        long publishedCount = this.sheetService.countByStatus(PostStatus.PUBLISHED);
        if (publishedCount > 0L) {
            return;
        }
        SheetParam sheetParam = new SheetParam();
        sheetParam.setSlug("about");
        sheetParam.setTitle("\u5173\u4e8e\u9875\u9762");
        sheetParam.setStatus(PostStatus.PUBLISHED);
        sheetParam.setOriginalContent("## \u5173\u4e8e\u9875\u9762\n\n\u8fd9\u662f\u4e00\u4e2a\u81ea\u5b9a\u4e49\u9875\u9762\uff0c\u4f60\u53ef\u4ee5\u5728\u540e\u53f0\u7684 `\u9875\u9762` -> `\u6240\u6709\u9875\u9762` -> `\u81ea\u5b9a\u4e49\u9875\u9762` \u627e\u5230\u5b83\uff0c\u4f60\u53ef\u4ee5\u7528\u4e8e\u65b0\u5efa\u5173\u4e8e\u9875\u9762\u3001\u7559\u8a00\u677f\u9875\u9762\u7b49\u7b49\u3002\u53d1\u6325\u4f60\u81ea\u5df1\u7684\u60f3\u8c61\u529b\uff01\n\n> \u8fd9\u662f\u4e00\u7bc7\u81ea\u52a8\u751f\u6210\u7684\u9875\u9762\uff0c\u4f60\u53ef\u4ee5\u5728\u540e\u53f0\u5220\u9664\u5b83\u3002");
        this.sheetService.createBy(sheetParam.convertTo(), false);
    }

    @Nullable
    private Category createDefaultCategoryIfAbsent() {
        long categoryCount = this.categoryService.count();
        if (categoryCount > 0L) {
            return null;
        }
        CategoryParam category = new CategoryParam();
        category.setName("\u9ed8\u8ba4\u5206\u7c7b");
        category.setSlug("default");
        category.setDescription("\u8fd9\u662f\u4f60\u7684\u9ed8\u8ba4\u5206\u7c7b\uff0c\u5982\u4e0d\u9700\u8981\uff0c\u5220\u9664\u5373\u53ef\u3002");
        ValidationUtils.validate((Object)category, (Class[])new Class[0]);
        return (Category)this.categoryService.create((Object)category.convertTo());
    }

    private User createUser(InstallParam installParam) {
        return this.userService.getCurrentUser().map(user -> {
            installParam.update(user);
            this.userService.setPassword(user, installParam.getPassword());
            return (User)this.userService.update(user);
        }).orElseGet(() -> {
            String gravatar = "//cn.gravatar.com/avatar/" + DigestUtils.md5Hex((String)installParam.getEmail()) + "?s=256&d=mm";
            installParam.setAvatar(gravatar);
            return this.userService.createBy((UserParam)installParam);
        });
    }

    private void initSettings(InstallParam installParam) {
        HashMap<Object, String> properties = new HashMap<Object, String>(11);
        properties.put(PrimaryProperties.IS_INSTALLED, Boolean.TRUE.toString());
        properties.put(BlogProperties.BLOG_LOCALE, installParam.getLocale());
        properties.put(BlogProperties.BLOG_TITLE, installParam.getTitle());
        properties.put(BlogProperties.BLOG_URL, StringUtils.isBlank((CharSequence)installParam.getUrl()) ? this.optionService.getBlogBaseUrl() : installParam.getUrl());
        properties.put(OtherProperties.GLOBAL_ABSOLUTE_PATH_ENABLED, Boolean.FALSE.toString());
        properties.put(PrimaryProperties.BIRTHDAY, String.valueOf(DateUtils.now().getTime()));
        this.optionService.saveProperties(properties);
    }
}

