/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.controller.admin.api;

import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.PageableDefault;
import org.springframework.data.web.SortDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import run.halo.app.model.dto.BaseCommentDTO;
import run.halo.app.model.entity.BaseComment;
import run.halo.app.model.entity.JournalComment;
import run.halo.app.model.enums.CommentStatus;
import run.halo.app.model.params.BaseCommentParam;
import run.halo.app.model.params.CommentQuery;
import run.halo.app.model.params.JournalCommentParam;
import run.halo.app.model.vo.BaseCommentVO;
import run.halo.app.model.vo.BaseCommentWithParentVO;
import run.halo.app.model.vo.JournalCommentWithJournalVO;
import run.halo.app.service.JournalCommentService;
import run.halo.app.service.OptionService;
import run.halo.app.service.assembler.comment.JournalCommentAssembler;

@RestController
@RequestMapping(value={"/api/admin/journals/comments"})
public class JournalCommentController {
    private final JournalCommentAssembler journalCommentAssembler;
    private final JournalCommentService journalCommentService;
    private final OptionService optionService;

    public JournalCommentController(JournalCommentAssembler journalCommentAssembler, JournalCommentService journalCommentService, OptionService optionService) {
        this.journalCommentAssembler = journalCommentAssembler;
        this.journalCommentService = journalCommentService;
        this.optionService = optionService;
    }

    @GetMapping
    @ApiOperation(value="Lists journal comments")
    public Page<JournalCommentWithJournalVO> pageBy(@PageableDefault(sort={"createTime"}, direction=Sort.Direction.DESC) Pageable pageable, CommentQuery commentQuery) {
        Page journalCommentPage = this.journalCommentService.pageBy(commentQuery, pageable);
        return this.journalCommentAssembler.convertToWithJournalVo(journalCommentPage);
    }

    @GetMapping(value={"latest"})
    @ApiOperation(value="Lists latest journal comments")
    public List<JournalCommentWithJournalVO> listLatest(@RequestParam(name="top", defaultValue="10") int top, @RequestParam(name="status", required=false) CommentStatus status) {
        List latestComments = this.journalCommentService.pageLatest(top, status).getContent();
        return this.journalCommentAssembler.convertToWithJournalVo(latestComments);
    }

    @GetMapping(value={"{journalId:\\d+}/tree_view"})
    @ApiOperation(value="Lists comments with tree view")
    public Page<BaseCommentVO> listCommentTree(@PathVariable(value="journalId") Integer journalId, @RequestParam(name="page", required=false, defaultValue="0") int page, @SortDefault(sort={"createTime"}, direction=Sort.Direction.DESC) Sort sort) {
        return this.journalCommentService.pageVosAllBy(journalId, (Pageable)PageRequest.of((int)page, (int)this.optionService.getCommentPageSize(), (Sort)sort));
    }

    @GetMapping(value={"{journalId:\\d+}/list_view"})
    @ApiOperation(value="Lists comment with list view")
    public Page<BaseCommentWithParentVO> listComments(@PathVariable(value="journalId") Integer journalId, @RequestParam(name="page", required=false, defaultValue="0") int page, @SortDefault(sort={"createTime"}, direction=Sort.Direction.DESC) Sort sort) {
        return this.journalCommentService.pageWithParentVoBy(journalId, (Pageable)PageRequest.of((int)page, (int)this.optionService.getCommentPageSize(), (Sort)sort));
    }

    @PostMapping
    @ApiOperation(value="Creates a journal comment")
    public BaseCommentDTO createCommentBy(@RequestBody JournalCommentParam journalCommentParam) {
        JournalComment journalComment = (JournalComment)this.journalCommentService.createBy((BaseCommentParam)journalCommentParam);
        return this.journalCommentAssembler.convertTo((BaseComment)journalComment);
    }

    @PutMapping(value={"{commentId:\\d+}/status/{status}"})
    @ApiOperation(value="Updates comment status")
    public BaseCommentDTO updateStatusBy(@PathVariable(value="commentId") Long commentId, @PathVariable(value="status") CommentStatus status) {
        JournalComment updatedJournalComment = (JournalComment)this.journalCommentService.updateStatus(commentId, status);
        return this.journalCommentAssembler.convertTo((BaseComment)updatedJournalComment);
    }

    @PutMapping(value={"/{commentId:\\d+}"})
    @ApiOperation(value="Updates a journal comment by comment id")
    public BaseCommentDTO updateCommentBy(@PathVariable Long commentId, @RequestBody JournalCommentParam journalCommentParam) {
        JournalComment commentToUpdate = (JournalComment)this.journalCommentService.getById((Object)commentId);
        journalCommentParam.update((Object)commentToUpdate);
        return this.journalCommentAssembler.convertTo((BaseComment)((JournalComment)this.journalCommentService.update((Object)commentToUpdate)));
    }

    @DeleteMapping(value={"{commentId:\\d+}"})
    @ApiOperation(value="Deletes comment permanently and recursively")
    public BaseCommentDTO deleteBy(@PathVariable(value="commentId") Long commentId) {
        JournalComment deletedJournalComment = (JournalComment)this.journalCommentService.removeById((Object)commentId);
        return this.journalCommentAssembler.convertTo((BaseComment)deletedJournalComment);
    }
}

