/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.controller.admin.api;

import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import run.halo.app.model.dto.JournalDTO;
import run.halo.app.model.dto.JournalWithCmtCountDTO;
import run.halo.app.model.entity.Journal;
import run.halo.app.model.params.JournalParam;
import run.halo.app.model.params.JournalQuery;
import run.halo.app.service.JournalService;

@RestController
@RequestMapping(value={"/api/admin/journals"})
public class JournalController {
    private final JournalService journalService;

    public JournalController(JournalService journalService) {
        this.journalService = journalService;
    }

    @GetMapping
    @ApiOperation(value="Lists journals")
    public Page<JournalWithCmtCountDTO> pageBy(@PageableDefault(sort={"createTime"}, direction=Sort.Direction.DESC) Pageable pageable, JournalQuery journalQuery) {
        Page journalPage = this.journalService.pageBy(journalQuery, pageable);
        return this.journalService.convertToCmtCountDto(journalPage);
    }

    @GetMapping(value={"latest"})
    @ApiOperation(value="Gets latest journals")
    public List<JournalWithCmtCountDTO> pageLatest(@RequestParam(name="top", defaultValue="10") int top) {
        List journals = this.journalService.pageLatest(top).getContent();
        return this.journalService.convertToCmtCountDto(journals);
    }

    @PostMapping
    @ApiOperation(value="Creates a journal")
    public JournalDTO createBy(@RequestBody @Valid JournalParam journalParam) {
        Journal createdJournal = this.journalService.createBy(journalParam);
        return this.journalService.convertTo(createdJournal);
    }

    @PutMapping(value={"{id:\\d+}"})
    @ApiOperation(value="Updates a Journal")
    public JournalDTO updateBy(@PathVariable(value="id") Integer id, @RequestBody @Valid JournalParam journalParam) {
        Journal journal = (Journal)this.journalService.getById((Object)id);
        journalParam.update(journal);
        Journal updatedJournal = this.journalService.updateBy(journal);
        return this.journalService.convertTo(updatedJournal);
    }

    @DeleteMapping(value={"{journalId:\\d+}"})
    @ApiOperation(value="Delete journal")
    public JournalDTO deleteBy(@PathVariable(value="journalId") Integer journalId) {
        Journal deletedJournal = (Journal)this.journalService.removeById((Object)journalId);
        return this.journalService.convertTo(deletedJournal);
    }
}

