/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.controller.admin.api;

import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.SortDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import run.halo.app.model.dto.LinkDTO;
import run.halo.app.model.entity.Link;
import run.halo.app.model.params.LinkParam;
import run.halo.app.service.LinkService;

@RestController
@RequestMapping(value={"/api/admin/links"})
public class LinkController {
    private final LinkService linkService;

    public LinkController(LinkService linkService) {
        this.linkService = linkService;
    }

    @GetMapping
    @ApiOperation(value="Lists links")
    public List<LinkDTO> listLinks(@SortDefault(sort={"team"}, direction=Sort.Direction.DESC) Sort sort) {
        return this.linkService.listDtos(sort.and(Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"priority"})));
    }

    @GetMapping(value={"{id:\\d+}"})
    @ApiOperation(value="Gets link detail by id")
    public LinkDTO getBy(@PathVariable(value="id") Integer id) {
        return (LinkDTO)new LinkDTO().convertFrom((Object)((Link)this.linkService.getById((Object)id)));
    }

    @PostMapping
    @ApiOperation(value="Creates a link")
    public LinkDTO createBy(@RequestBody @Valid LinkParam linkParam) {
        Link link = this.linkService.createBy(linkParam);
        return (LinkDTO)new LinkDTO().convertFrom((Object)link);
    }

    @PutMapping(value={"{id:\\d+}"})
    @ApiOperation(value="Updates a link")
    public LinkDTO updateBy(@PathVariable(value="id") Integer id, @RequestBody @Valid LinkParam linkParam) {
        Link link = this.linkService.updateBy(id, linkParam);
        return (LinkDTO)new LinkDTO().convertFrom((Object)link);
    }

    @DeleteMapping(value={"{id:\\d+}"})
    @ApiOperation(value="Delete link by id")
    public void deletePermanently(@PathVariable(value="id") Integer id) {
        this.linkService.removeById((Object)id);
    }

    @GetMapping(value={"teams"})
    @ApiOperation(value="Lists all link teams")
    public List<String> teams() {
        return this.linkService.listAllTeams();
    }
}

