/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.controller.admin.api;

import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import run.halo.app.model.dto.LogDTO;
import run.halo.app.service.LogService;

@RestController
@RequestMapping(value={"/api/admin/logs"})
public class LogController {
    private final LogService logService;

    public LogController(LogService logService) {
        this.logService = logService;
    }

    @GetMapping(value={"latest"})
    @ApiOperation(value="Pages latest logs")
    public List<LogDTO> pageLatest(@RequestParam(name="top", defaultValue="10") int top) {
        return this.logService.pageLatest(top).getContent();
    }

    @GetMapping
    @ApiOperation(value="Lists logs")
    public Page<LogDTO> pageBy(@PageableDefault(sort={"createTime"}, direction=Sort.Direction.DESC) Pageable pageable) {
        Page logPage = this.logService.listAll(pageable);
        return logPage.map(log -> (LogDTO)new LogDTO().convertFrom(log));
    }

    @GetMapping(value={"clear"})
    @ApiOperation(value="Clears all logs")
    public void clear() {
        this.logService.removeAll();
    }
}

